/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.testimpact.MethodId;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ImpactReason {
    private final @Nullable Long timestampOfLastChange;
    private final @Nullable ETestExecutionResult lastTestExecutionResult;
    private final HashMap<MethodId, Long> changedMethods = new HashMap();

    static ImpactReason codeChangeAt(long timestamp, Collection<MethodId> changedMethods) {
        HashMap<MethodId, Long> methods = new HashMap<MethodId, Long>();
        for (MethodId changedMethod : changedMethods) {
            methods.put(changedMethod, timestamp);
        }
        return new ImpactReason(timestamp, methods, null);
    }

    static ImpactReason codeDeletionAt(long timestamp) {
        HashMap<MethodId, Long> methods = new HashMap<MethodId, Long>();
        return new ImpactReason(timestamp, methods, null);
    }

    static ImpactReason testResultOf(ETestExecutionResult executionResult) {
        return new ImpactReason(null, null, executionResult);
    }

    ImpactReason(@Nullable Long timestampOfLastChange, @Nullable HashMap<MethodId, Long> changedMethods, @Nullable ETestExecutionResult lastTestExecutionResult) {
        this.timestampOfLastChange = timestampOfLastChange;
        if (changedMethods != null) {
            this.changedMethods.putAll(changedMethods);
        }
        this.lastTestExecutionResult = lastTestExecutionResult;
    }

    static ImpactReason merge(ImpactReason v1, ImpactReason v2) {
        ETestExecutionResult result;
        Long timestamp = v1.timestampOfLastChange;
        if (timestamp == null || v2.timestampOfLastChange != null && v2.timestampOfLastChange > timestamp) {
            timestamp = v2.timestampOfLastChange;
        }
        if ((result = v1.lastTestExecutionResult) == null || v2.lastTestExecutionResult != null && v2.lastTestExecutionResult.ordinal() > result.ordinal()) {
            result = v2.lastTestExecutionResult;
        }
        HashMap<MethodId, Long> changedMethods = ImpactReason.merge(v1.changedMethods, v2.changedMethods);
        return new ImpactReason(timestamp, changedMethods, result);
    }

    private static HashMap<MethodId, Long> merge(HashMap<MethodId, Long> a, HashMap<MethodId, Long> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        b.forEach((key, value) -> a.merge((MethodId)key, (Long)value, Math::max));
        return a;
    }

    public <E extends Exception> boolean transform(FunctionWithException<MethodId, Optional<MethodId>, E> mapping) throws E {
        HashMap<MethodId, Long> mappedChangedMethods = new HashMap<MethodId, Long>();
        boolean hadChanges = false;
        for (MethodId method : this.changedMethods.keySet()) {
            Optional mappedMethod = (Optional)mapping.apply((Object)method);
            if (mappedMethod.isEmpty()) {
                hadChanges = true;
                continue;
            }
            hadChanges = hadChanges || !method.equals(mappedMethod.get());
            mappedChangedMethods.put((MethodId)mappedMethod.get(), this.changedMethods.get(method));
        }
        this.changedMethods.clear();
        this.changedMethods.putAll(mappedChangedMethods);
        return hadChanges;
    }

    public boolean isFailReason() {
        return EnumSet.of(ETestExecutionResult.ERROR, ETestExecutionResult.FAILURE).contains(this.lastTestExecutionResult);
    }

    public boolean isSkipReason() {
        return EnumSet.of(ETestExecutionResult.IGNORED, ETestExecutionResult.SKIPPED).contains(this.lastTestExecutionResult);
    }

    public boolean isCodeChangeReasonAfter(long baseline) {
        return this.timestampOfLastChange != null && this.timestampOfLastChange > baseline;
    }

    public Set<MethodId> getChangedMethodLocations(long baselineTimestamp) {
        return this.changedMethods.entrySet().stream().filter(entry -> (Long)entry.getValue() > baselineTimestamp).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    HashMap<MethodId, Long> getChangedMethods() {
        return this.changedMethods;
    }

    @Nullable ETestExecutionResult getLastTestExecutionResult() {
        return this.lastTestExecutionResult;
    }

    @Nullable Long getTimestampOfLastChange() {
        return this.timestampOfLastChange;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImpactReason that = (ImpactReason)o;
        return Objects.equals(this.timestampOfLastChange, that.timestampOfLastChange) && this.lastTestExecutionResult == that.lastTestExecutionResult && Objects.equals(this.changedMethods, that.changedMethods);
    }

    public int hashCode() {
        return Objects.hash(this.timestampOfLastChange, this.lastTestExecutionResult, this.changedMethods);
    }
}

