/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.teamscale.index.testimpact.TemporarySapTestInfoIndex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ManualSapTestInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String executingUser;
    private final int id;
    private final InternalProjectId projectId;
    private ETestExecutionResult result;
    private final List<Long> startTimestamps = new ArrayList<Long>();
    private long duration = 0L;
    private String name;
    private String message;
    private String report;
    private String logMessages;
    private SapTestStatus status = SapTestStatus.RUNNING;

    public ManualSapTestInfo(int id, String executingUser, InternalProjectId projectId, ETestExecutionResult result, String name, String message) {
        this.id = id;
        this.executingUser = executingUser.toUpperCase();
        this.projectId = projectId;
        this.result = result;
        this.name = name;
        this.message = message;
        this.startTimestamps.add(System.currentTimeMillis());
    }

    public void update(ManualSapTestInfo other) {
        Optional.ofNullable(other.result).ifPresent(result -> {
            this.result = result;
        });
        Optional.ofNullable(other.name).ifPresent(name -> {
            this.name = name;
        });
        Optional.ofNullable(other.message).ifPresent(message -> {
            this.message = message;
        });
    }

    public void pauseTimer() {
        if (this.status != SapTestStatus.RUNNING) {
            return;
        }
        this.duration += System.currentTimeMillis() - this.getLastStartOrResumeTimestamp();
        this.status = SapTestStatus.PAUSED;
    }

    public void setAsEnded() {
        this.pauseTimer();
        this.status = SapTestStatus.ENDED;
    }

    public void resumeTimer() {
        if (this.status != SapTestStatus.PAUSED) {
            return;
        }
        this.startTimestamps.add(System.currentTimeMillis());
    }

    public String makeKey() {
        return TemporarySapTestInfoIndex.makeKey(this);
    }

    public InternalProjectId getProjectId() {
        return this.projectId;
    }

    public String getExecutingUser() {
        return this.executingUser;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public synchronized double getDuration() {
        if (this.status == SapTestStatus.RUNNING) {
            return (double)(this.duration + System.currentTimeMillis() - this.getLastStartOrResumeTimestamp()) / 1000.0;
        }
        return (double)this.duration / 1000.0;
    }

    public ETestExecutionResult getResult() {
        return this.result;
    }

    public String getOutput() {
        return this.message;
    }

    public boolean isUnfinished() {
        return this.status == SapTestStatus.RUNNING || this.status == SapTestStatus.PAUSED;
    }

    public boolean isReadyToBeFetched() {
        return this.status == SapTestStatus.ENDED;
    }

    public boolean isOld() {
        return this.status == SapTestStatus.PROCESSED && (double)this.getLastStartOrResumeTimestamp() + this.getDuration() < (double)(System.currentTimeMillis() - 86400000L) || this.getLastStartOrResumeTimestamp() < System.currentTimeMillis() - 604800000L;
    }

    public long getStartTimestamp() {
        return this.startTimestamps.get(0);
    }

    public long getLastStartOrResumeTimestamp() {
        return this.startTimestamps.get(this.startTimestamps.size() - 1);
    }

    public String getLogMessages() {
        return this.logMessages;
    }

    public void setLogMessagesAfterProcessing(String logMessages) {
        this.logMessages = logMessages;
        this.status = SapTestStatus.PROCESSED;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public String toString() {
        return "ManualSapTestInfo [makeKey()=" + this.makeKey() + ", getProjectId()=" + String.valueOf(this.getProjectId()) + ", getExecutingUser()=" + this.getExecutingUser() + ", getId()=" + this.getId() + ", getName()=" + this.getName() + ", getDuration()=" + this.getDuration() + ", getResult()=" + String.valueOf(this.getResult()) + ", getOutput()=" + this.getOutput() + ", isReadyToBeFetched()=" + this.isReadyToBeFetched() + "]";
    }

    @IndexValueClass
    private static enum SapTestStatus {
        RUNNING,
        PAUSED,
        ENDED,
        PROCESSED;

    }
}

