/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rules;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.IOUtils;

public class OthersSectionHtmlContent {
    private static final String FOLDER_NAME = "/context-rule-description/";
    private static final String FILE_EXTENSION = ".html";
    private static final String UNSUPPORTED_RULE_DESCRIPTION_FOR_CONTEXT_KEY = "Unsupported rule description for context key: ";
    private static final String ERROR_READING_FILE_CONTENT = "Could not read the content for rule description for context key: ";
    private static final String OTHERS_SECTION_HTML_CONTENT_KEY = "others_section_html_content";

    private OthersSectionHtmlContent() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHtmlContent() {
        try (InputStream htmlContentFile = OthersSectionHtmlContent.class.getResourceAsStream("/context-rule-description/others_section_html_content.html");){
            if (htmlContentFile == null) {
                SonarLintLogger.get().info("Unsupported rule description for context key: others_section_html_content");
                String string2 = "";
                return string2;
            }
            String string = IOUtils.toString(htmlContentFile, StandardCharsets.UTF_8).trim().replaceAll("\\r\\n?", "\n");
            return string;
        }
        catch (IOException ioException) {
            SonarLintLogger.get().error("Could not read the content for rule description for context key: others_section_html_content", ioException);
            return "";
        }
    }
}

