/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.util.Arrays;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.types.AbstractCell;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Sink;

class MatCell
extends AbstractCell
implements Mat5Serializable {
    MatCell(int[] dims) {
        super(dims, new Array[MatCell.getNumElements(dims)]);
        Arrays.fill(this.contents, this.getEmptyValue());
    }

    MatCell(int[] dims, Array[] contents) {
        super(dims, contents);
    }

    @Override
    protected Array getEmptyValue() {
        return Mat5.EMPTY_MATRIX;
    }

    @Override
    public int getMat5Size(String name) {
        int size = 8;
        size += Mat5WriteUtil.computeArrayHeaderSize(name, this);
        for (int i = 0; i < this.getNumElements(); ++i) {
            size += Mat5WriteUtil.computeArraySize(this.get(i));
        }
        return size;
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        Mat5WriteUtil.writeMatrixTag(name, this, sink);
        Mat5WriteUtil.writeArrayHeader(name, isGlobal, this, sink);
        for (int i = 0; i < this.getNumElements(); ++i) {
            Mat5WriteUtil.writeNestedArray(this.get(i), sink);
        }
    }

    @Override
    protected int subHashCode() {
        return Arrays.hashCode(this.contents);
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        MatCell other = (MatCell)otherGuaranteedSameClass;
        return Arrays.equals(other.contents, this.contents);
    }
}

