/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.hebi.matlab.mat.types.AbstractMatFileBase;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.StringHelper;

public abstract class AbstractMatFile
extends AbstractMatFileBase {
    protected final HashMap<String, Array> lookup = new HashMap();
    protected final List<MatFile.Entry> entries = new ArrayList<MatFile.Entry>();
    protected MatFile.Entry subsystem = null;

    @Override
    public <T extends Array> T getArray(String name) {
        Array array = this.lookup.get(name);
        if (array != null) {
            return (T)array;
        }
        for (MatFile.Entry entry : this.entries) {
            if (!name.equalsIgnoreCase(entry.getName())) continue;
            return (T)entry.getValue();
        }
        throw new IllegalArgumentException("Could not find array: " + name);
    }

    @Override
    public <T extends Array> T getArray(int index) {
        return (T)this.entries.get(index).getValue();
    }

    @Override
    public MatFile addArray(String name, Array value) {
        return this.addArray(name, false, value);
    }

    @Override
    public MatFile addArray(String name, boolean isGlobal, Array value) {
        return this.addEntry(new MatFile.Entry(name, isGlobal, value));
    }

    @Override
    public MatFile addEntry(MatFile.Entry entry) {
        this.entries.add(entry);
        this.lookup.put(entry.getName(), entry.getValue());
        return this;
    }

    public String toString() {
        String content = StringHelper.toString(this.entries);
        if (this.subsystem != null) {
            content = content + "\n== subsystem ==\n" + this.subsystem;
        }
        return content;
    }

    @Override
    public void close() throws IOException {
        IOException lastError = null;
        for (MatFile.Entry entry : this.entries) {
            try {
                entry.getValue().close();
            }
            catch (IOException ioe) {
                lastError = ioe;
            }
        }
        if (this.subsystem != null) {
            try {
                this.subsystem.getValue().close();
            }
            catch (IOException ioe) {
                lastError = ioe;
            }
        }
        this.clear();
        if (lastError != null) {
            throw lastError;
        }
    }

    @Override
    public Iterable<MatFile.Entry> getEntries() {
        return this.entries;
    }

    @Override
    public int getNumEntries() {
        return this.entries.size();
    }

    @Override
    public MatFile.Entry getSubsystem() {
        return this.subsystem;
    }

    @Override
    public void clear() {
        this.lookup.clear();
        this.entries.clear();
        this.subsystem = null;
    }

    public final int hashCode() {
        return 31 * this.subHashCode() + this.entries.hashCode();
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass().equals(this.getClass())) {
            AbstractMatFile otherFile = (AbstractMatFile)other;
            return this.subEqualsGuaranteedSameClass(other) && otherFile.entries.equals(this.entries);
        }
        return false;
    }

    protected abstract int subHashCode();

    protected abstract boolean subEqualsGuaranteedSameClass(Object var1);
}

