/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.persistent.PersistentBitTreeLongMap;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongMap;
import jetbrains.exodus.io.Block;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003,-.B\u001d\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0003J\u0012\u0010&\u001a\u00020\t2\b\b\u0002\u0010'\u001a\u00020\u0013H\u0007J\u0010\u0010(\u001a\u00020)2\b\b\u0002\u0010$\u001a\u00020\u0003J\u0006\u0010*\u001a\u00020+R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u0003*\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u00020\u0003*\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001e\u0082\u0001\u0002/\"\u00a8\u00060"}, d2={"Ljetbrains/exodus/log/BlockSet;", "", "blockSize", "", "set", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;", "Ljetbrains/exodus/io/Block;", "(JLjetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;)V", "array", "", "getArray", "()[J", "getBlockSize", "()J", "current", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap$ImmutableMap;", "getCurrent", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap$ImmutableMap;", "isEmpty", "", "()Z", "maximum", "getMaximum", "()Ljava/lang/Long;", "minimum", "getMinimum", "getSet", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;", "addressToKey", "getAddressToKey", "(J)J", "keyToAddress", "getKeyToAddress", "beginWrite", "Ljetbrains/exodus/log/BlockSet$Mutable;", "contains", "blockAddress", "getBlock", "getFiles", "reversed", "getFilesFrom", "Ljetbrains/exodus/core/dataStructures/hash/LongIterator;", "size", "", "EmptyBlock", "Immutable", "Mutable", "Ljetbrains/exodus/log/BlockSet$Immutable;", "xodus-environment"})
public abstract class BlockSet {
    private final long blockSize;
    @NotNull
    private final PersistentLongMap<Block> set;

    private BlockSet(long blockSize, PersistentLongMap<Block> set) {
        this.blockSize = blockSize;
        this.set = set;
    }

    public final long getBlockSize() {
        return this.blockSize;
    }

    @NotNull
    public final PersistentLongMap<Block> getSet() {
        return this.set;
    }

    @NotNull
    protected abstract PersistentLongMap.ImmutableMap<Block> getCurrent();

    public final int size() {
        return this.getCurrent().size();
    }

    public final boolean isEmpty() {
        return this.getCurrent().isEmpty();
    }

    @Nullable
    public final Long getMinimum() {
        Iterator it = this.getCurrent().iterator();
        boolean bl = false;
        return it.hasNext() ? Long.valueOf(this.getKeyToAddress(((PersistentLongMap.Entry)it.next()).getKey())) : null;
    }

    @Nullable
    public final Long getMaximum() {
        Iterator it = this.getCurrent().reverseIterator();
        boolean bl = false;
        return it.hasNext() ? Long.valueOf(this.getKeyToAddress(((PersistentLongMap.Entry)it.next()).getKey())) : null;
    }

    @NotNull
    public final long[] getArray() {
        return this.getFiles(true);
    }

    @JvmOverloads
    @NotNull
    public final long[] getFiles(boolean reversed) {
        PersistentLongMap.ImmutableMap<Block> current = this.getCurrent();
        long[] result = new long[current.size()];
        Iterator it = reversed ? current.reverseIterator() : current.iterator();
        int n = 0;
        int n2 = result.length;
        while (n < n2) {
            int i = n++;
            result[i] = this.getKeyToAddress(((PersistentLongMap.Entry)it.next()).getKey());
        }
        return result;
    }

    public static /* synthetic */ long[] getFiles$default(BlockSet blockSet, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFiles");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return blockSet.getFiles(bl);
    }

    public final boolean contains(long blockAddress) {
        return this.getCurrent().containsKey(this.getAddressToKey(blockAddress));
    }

    @NotNull
    public final Block getBlock(long blockAddress) {
        Block block = (Block)this.getCurrent().get(this.getAddressToKey(blockAddress));
        if (block == null) {
            block = new EmptyBlock(blockAddress);
        }
        return block;
    }

    @NotNull
    public final LongIterator getFilesFrom(long blockAddress) {
        return new LongIterator(blockAddress, this){
            private final Iterator<PersistentLongMap.Entry<Block>> it;
            final /* synthetic */ long $blockAddress;
            final /* synthetic */ BlockSet this$0;
            {
                this.$blockAddress = $blockAddress;
                this.this$0 = $receiver;
                this.it = this.$blockAddress == 0L ? this.this$0.getCurrent().iterator() : this.this$0.getCurrent().tailEntryIterator(this.this$0.getAddressToKey(this.$blockAddress));
            }

            public final Iterator<PersistentLongMap.Entry<Block>> getIt() {
                return this.it;
            }

            @NotNull
            public Long next() {
                return this.nextLong();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public long nextLong() {
                return this.this$0.getKeyToAddress(this.it.next().getKey());
            }

            @NotNull
            public Void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static /* synthetic */ LongIterator getFilesFrom$default(BlockSet blockSet, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesFrom");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return blockSet.getFilesFrom(l);
    }

    @NotNull
    public final Mutable beginWrite() {
        PersistentLongMap persistentLongMap = this.set.getClone();
        Intrinsics.checkNotNullExpressionValue((Object)persistentLongMap, (String)"set.clone");
        return new Mutable(this.blockSize, (PersistentLongMap<Block>)persistentLongMap);
    }

    protected final long getKeyToAddress(long $this$keyToAddress) {
        return $this$keyToAddress * this.blockSize;
    }

    protected final long getAddressToKey(long $this$addressToKey) {
        return $this$addressToKey / this.blockSize;
    }

    @JvmOverloads
    @NotNull
    public final long[] getFiles() {
        return BlockSet.getFiles$default(this, false, 1, null);
    }

    public /* synthetic */ BlockSet(long blockSize, PersistentLongMap set, DefaultConstructorMarker $constructor_marker) {
        this(blockSize, (PersistentLongMap<Block>)set);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/log/BlockSet$Immutable;", "Ljetbrains/exodus/log/BlockSet;", "blockSize", "", "map", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;", "Ljetbrains/exodus/io/Block;", "(JLjetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;)V", "current", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap$ImmutableMap;", "getCurrent", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap$ImmutableMap;", "immutable", "xodus-environment"})
    public static final class Immutable
    extends BlockSet {
        @NotNull
        private final PersistentLongMap.ImmutableMap<Block> immutable;

        @JvmOverloads
        public Immutable(long blockSize, @NotNull PersistentLongMap<Block> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(blockSize, map, null);
            PersistentLongMap.ImmutableMap immutableMap = map.beginRead();
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"map.beginRead()");
            this.immutable = immutableMap;
        }

        public /* synthetic */ Immutable(long l, PersistentLongMap persistentLongMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                persistentLongMap = (PersistentLongMap)new PersistentBitTreeLongMap();
            }
            this(l, (PersistentLongMap<Block>)persistentLongMap);
        }

        @Override
        @NotNull
        public PersistentLongMap.ImmutableMap<Block> getCurrent() {
            return this.immutable;
        }

        @JvmOverloads
        public Immutable(long blockSize) {
            this(blockSize, null, 2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0003R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/exodus/log/BlockSet$Mutable;", "Ljetbrains/exodus/log/BlockSet;", "blockSize", "", "map", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;", "Ljetbrains/exodus/io/Block;", "(JLjetbrains/exodus/core/dataStructures/persistent/PersistentLongMap;)V", "current", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap$ImmutableMap;", "getCurrent", "()Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap$ImmutableMap;", "mutable", "Ljetbrains/exodus/core/dataStructures/persistent/PersistentLongMap$MutableMap;", "add", "", "blockAddress", "block", "clear", "endWrite", "Ljetbrains/exodus/log/BlockSet$Immutable;", "remove", "", "xodus-environment"})
    public static final class Mutable
    extends BlockSet {
        @NotNull
        private final PersistentLongMap.MutableMap<Block> mutable;

        public Mutable(long blockSize, @NotNull PersistentLongMap<Block> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(blockSize, map, null);
            PersistentLongMap.MutableMap mutableMap = this.getSet().beginWrite();
            Intrinsics.checkNotNullExpressionValue((Object)mutableMap, (String)"set.beginWrite()");
            this.mutable = mutableMap;
        }

        @Override
        @NotNull
        protected PersistentLongMap.ImmutableMap<Block> getCurrent() {
            return (PersistentLongMap.ImmutableMap)this.mutable;
        }

        public final void clear() {
            this.mutable.clear();
        }

        public final void add(long blockAddress, @NotNull Block block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.mutable.put(this.getAddressToKey(blockAddress), (Object)block);
        }

        public final boolean remove(long blockAddress) {
            return this.mutable.remove(this.getAddressToKey(blockAddress)) != null;
        }

        @NotNull
        public final Immutable endWrite() {
            if (!this.mutable.endWrite()) {
                throw new IllegalStateException("File set can't be updated");
            }
            long l = this.getBlockSize();
            PersistentLongMap persistentLongMap = this.getSet().getClone();
            Intrinsics.checkNotNullExpressionValue((Object)persistentLongMap, (String)"set.clone");
            return new Immutable(l, (PersistentLongMap<Block>)persistentLongMap);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\f\u0010\u000e\u001a\u00060\u0000R\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/log/BlockSet$EmptyBlock;", "Ljetbrains/exodus/io/Block;", "address", "", "(Ljetbrains/exodus/log/BlockSet;J)V", "getAddress", "length", "read", "", "output", "", "position", "offset", "count", "refresh", "Ljetbrains/exodus/log/BlockSet;", "xodus-environment"})
    private final class EmptyBlock
    implements Block {
        private final long address;

        public EmptyBlock(long address) {
            Intrinsics.checkNotNullParameter((Object)BlockSet.this, (String)"this$0");
            this.address = address;
        }

        public long getAddress() {
            return this.address;
        }

        public long length() {
            return 0L;
        }

        public int read(@NotNull byte[] output, long position, int offset, int count) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            return 0;
        }

        @NotNull
        public EmptyBlock refresh() {
            return this;
        }
    }
}

