/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.dotnet.LookupBasedCoverageCreator;
import org.conqat.lib.commons.enums.EnumValueMap;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VsCoverageReportParser
extends CoverageReportParserBase {
    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) throws ReportParserException {
        LookupBasedCoverageCreator coverageCreator = new LookupBasedCoverageCreator(retriever);
        VsCoverageHandler lineCoverageHandler = new VsCoverageHandler(coverageCreator);
        try {
            XMLUtils.parseSAX((String)report, (DefaultHandler)lineCoverageHandler);
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException(e);
        }
        coverageCreator.storeCoverageInfo();
    }

    public static class VsCoverageHandler
    extends DefaultHandler {
        private LookupBasedCoverageCreator coverageCreator;

        public VsCoverageHandler(LookupBasedCoverageCreator coverageCreator) {
            this.coverageCreator = coverageCreator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            EElement element = (EElement)EElement.VALUES.valueOf(localName);
            if (element == null) {
                return;
            }
            switch (element.ordinal()) {
                case 0: {
                    this.handleSourceFile(attributes);
                    break;
                }
                case 1: {
                    this.handleRange(attributes);
                    break;
                }
                case 2: {
                    this.coverageCreator.storeCoverageInfo();
                }
            }
        }

        private void handleSourceFile(Attributes attributes) {
            Integer id = VsCoverageHandler.getIntValue(attributes, EAttribute.id);
            String path = attributes.getValue(EAttribute.path.name());
            this.coverageCreator.storeFileMapping(id.intValue(), path);
        }

        private void handleRange(Attributes attributes) {
            Integer sourceFileID = VsCoverageHandler.getIntValue(attributes, EAttribute.source_id);
            int lineStart = VsCoverageHandler.getIntValue(attributes, EAttribute.start_line);
            int lineEnd = VsCoverageHandler.getIntValue(attributes, EAttribute.end_line);
            String covered = attributes.getValue(EAttribute.covered.name());
            this.coverageCreator.addLineCoverage(sourceFileID.intValue(), lineStart, lineEnd, ECoverage.valueOf((String)covered).coverage);
        }

        private static int getIntValue(Attributes attributes, EAttribute name) {
            return Integer.parseInt(attributes.getValue(name.name()));
        }
    }

    private static enum ECoverage {
        yes(ELineCoverage.FULLY_COVERED),
        no(ELineCoverage.NOT_COVERED),
        partial(ELineCoverage.PARTIALLY_COVERED);

        private ELineCoverage coverage;

        private ECoverage(ELineCoverage coverage) {
            this.coverage = coverage;
        }
    }

    private static enum EAttribute {
        id,
        source_id,
        covered,
        start_line,
        end_line,
        path;

    }

    private static enum EElement {
        source_file,
        range,
        module;

        public static final EnumValueMap<EElement> VALUES;

        static {
            VALUES = new EnumValueMap(EElement.class);
        }
    }
}

