/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclBase;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowEvent;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTarget;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.model.stateflow.StateflowTruthTable;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

class StateflowBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean preserveUnconnectedLines;
    private final HashMap<String, StateflowElementBase<?>> elements = new HashMap();
    private final SimulinkModel model;

    public StateflowBuilder(ModelBuildingParameters modelBuildingParameters, SimulinkModel model) {
        this.model = model;
        this.preserveUnconnectedLines = modelBuildingParameters.isPreserveUnconnectedLines();
    }

    public void buildStateflow(MDLSection stateflowSection, ModelDataHandler modelDataHandler) throws SimulinkModelBuildingException {
        this.buildMachine(stateflowSection.getFirstSubSection("machine"), modelDataHandler);
        for (MDLSection section : stateflowSection.getSubSections()) {
            StateflowElementBase<?> element = StateflowBuilder.createElementFromSection(section);
            if (element == null) continue;
            this.process(section, element);
        }
        for (StateflowElementBase element : this.elements.values()) {
            this.buildRelation(element);
        }
        for (MDLSection transition : stateflowSection.getSubSections("transition")) {
            this.buildTransition(transition);
        }
    }

    private static StateflowElementBase<?> createElementFromSection(MDLSection section) {
        String name = section.getName();
        if (name.equals("chart")) {
            return new StateflowChart();
        }
        if (name.equals("state")) {
            if (section.hasSubSections("truthTable")) {
                return new StateflowTruthTable();
            }
            return new StateflowState();
        }
        if (name.equals("junction")) {
            return new StateflowJunction();
        }
        if (name.equals("event")) {
            return new StateflowEvent();
        }
        if (name.equals("data")) {
            return new StateflowData();
        }
        if (name.equals("target")) {
            return new StateflowTarget();
        }
        return null;
    }

    private void buildMachine(MDLSection machineSection, ModelDataHandler modelDataHandler) throws SimulinkModelBuildingException {
        if (machineSection == null) {
            throw new SimulinkModelBuildingException("No Stateflow machine defined!");
        }
        StateflowMachine machine = new StateflowMachine(this.model, modelDataHandler);
        this.process(machineSection, machine);
    }

    private void process(MDLSection section, StateflowElementBase<?> element) throws SimulinkModelBuildingException {
        StateflowBuilder.addParameters(section, element);
        String id = element.getParameter("id");
        if (element instanceof StateflowState && "SUBCHART".equals(element.getParameter("superState"))) {
            StateflowChart chart = new StateflowChart();
            SimulinkUtils.copyParameters(element, chart);
            ((StateflowState)element).setSubViewer(chart);
        }
        if (element instanceof StateflowTruthTable) {
            StateflowTruthTable truthTable = (StateflowTruthTable)element;
            if (section.hasSubSections("eml")) {
                String script = section.getFirstSubSection("eml").getParameter("script", "");
                truthTable.setScript(script.replaceAll("\\\\n", "\n"));
            }
            if (section.hasSubSections("truthTable")) {
                UnmodifiableList<MDLSection> arrays = section.getFirstSubSection("truthTable").getSubSections();
                for (MDLSection array : arrays) {
                    truthTable.addTable(array.getParameter("PropName"), array.getParameter("Dimension"), array.getSubSections().stream().map(cell -> cell.getParameter("Teamscale_XML_Text_Content")).collect(Collectors.toList()));
                }
            }
        }
        if (id == null) {
            throw new SimulinkModelBuildingException("Element has no id.", section);
        }
        if (this.elements.containsKey(id)) {
            throw new SimulinkModelBuildingException("Duplicate id " + id + ".", section);
        }
        this.elements.put(id, element);
        String localId = StateflowUtils.extractIdFromStateflowId(id);
        if (!id.equals(localId) && !this.elements.containsKey(localId)) {
            this.elements.put(localId, element);
        }
    }

    private static void addParameters(MDLSection section, ParameterizedElement element) {
        for (Map.Entry<String, String> parameter : section.getParameterMapRecursively().entrySet()) {
            element.setParameter(parameter.getKey(), parameter.getValue());
        }
    }

    private void buildRelation(StateflowElementBase<?> element) throws SimulinkModelBuildingException {
        if (element instanceof StateflowState) {
            if (this.isTopLevelElementInSubView(element, "treeNode")) {
                this.addToChart(element);
            } else {
                this.buildNodeRelation((StateflowState)element, "treeNode");
            }
            return;
        }
        if (element instanceof StateflowJunction) {
            if (this.isTopLevelElementInSubView(element, "linkNode")) {
                this.addToChart(element);
            } else {
                this.buildNodeRelation((StateflowJunction)element, "linkNode");
            }
            return;
        }
        if (element instanceof StateflowEvent) {
            this.buildEventRelation((StateflowEvent)element);
            return;
        }
        if (element instanceof StateflowData) {
            this.buildDataRelation((StateflowData)element);
            return;
        }
        if (element instanceof StateflowTarget) {
            this.buildTargetRelation((StateflowTarget)element);
            return;
        }
        if (element instanceof StateflowChart) {
            this.buildChartRelation((StateflowChart)element);
            return;
        }
        if (element instanceof StateflowMachine) {
            return;
        }
        CCSMAssert.fail((String)("Unknown case: " + element.getClass().getName()));
    }

    private boolean isTopLevelElementInSubView(StateflowElementBase<?> element, String primaryRelationshipParam) throws SimulinkModelBuildingException {
        StateflowElementBase<?> parentSubview;
        StateflowElementBase<?> primaryParent = this.getRelatedElementFromArrayParameter(element, primaryRelationshipParam);
        return primaryParent == (parentSubview = this.getRelatedElementFromParameter(element));
    }

    private void addToChart(StateflowElementBase<?> element) throws SimulinkModelBuildingException {
        StateflowChart parentChart;
        StateflowElementBase<?> parentElement = this.getRelatedElementFromParameter(element);
        if (parentElement instanceof StateflowChart) {
            parentChart = (StateflowChart)parentElement;
        } else if (parentElement instanceof StateflowState) {
            CCSMAssert.isTrue((boolean)((StateflowState)parentElement).isSubChart(), (String)"StateflowChart is child of non-subchart StateflowState!");
            parentChart = ((StateflowState)parentElement).getSubViewer();
        } else {
            LOGGER.error("Found a simulink element with \"subviewer\" param that is not pointing to a stateflowState. StateflowId: " + element.getStateflowId());
            return;
        }
        if (element instanceof StateflowNodeBase) {
            parentChart.addNode((StateflowNodeBase)element);
        } else if (element instanceof StateflowData) {
            parentChart.addData((StateflowData)element);
        } else if (element instanceof StateflowEvent) {
            parentChart.addEvent((StateflowEvent)element);
        } else {
            LOGGER.warn("New StateflowNodeBase subclass is not handled in StateFlowBuilder.addToChart");
        }
    }

    private void buildNodeRelation(StateflowNodeBase node, String relationParam) throws SimulinkModelBuildingException {
        StateflowElementBase<?> relatedElement = this.getRelatedElementFromArrayParameter(node, relationParam);
        if (!(relatedElement instanceof IStateflowNodeContainer)) {
            throw new SimulinkModelBuildingException(String.valueOf(relatedElement) + " cannot be parent of " + String.valueOf(node));
        }
        IStateflowNodeContainer parent = (IStateflowNodeContainer)((Object)relatedElement);
        if (parent instanceof StateflowState && ((StateflowState)parent).isSubChart()) {
            ((StateflowState)parent).getSubViewer().addNode(node);
        } else {
            parent.addNode(node);
        }
    }

    private StateflowElementBase<?> getRelatedElementFromArrayParameter(StateflowElementBase<?> element, String relationshipParameter) throws SimulinkModelBuildingException {
        String array = element.getParameter(relationshipParameter);
        if (array == null) {
            throw new SimulinkModelBuildingException("Relationship parameter " + relationshipParameter + " not found for element with id " + element.getStateflowId() + ".");
        }
        String[] relationship = SimulinkUtils.getStringParameterArray(array);
        if (relationship.length == 0) {
            throw new SimulinkModelBuildingException("Relationship parameter " + relationshipParameter + " not found for element with id " + element.getStateflowId() + ".");
        }
        return this.elements.get(relationship[0]);
    }

    private StateflowElementBase<?> getRelatedElementFromParameter(StateflowElementBase<?> element) throws SimulinkModelBuildingException {
        String parameter = element.getParameter("subviewer");
        if (parameter == null) {
            throw new SimulinkModelBuildingException("Relationship parameter subviewer not found for element with id " + element.getStateflowId() + ".");
        }
        return this.elements.get(parameter);
    }

    private void buildEventRelation(StateflowEvent element) throws SimulinkModelBuildingException {
        StateflowDeclContainerBase<?> parent = this.determineParent(element);
        parent.addEvent(element);
    }

    private void buildDataRelation(StateflowData element) throws SimulinkModelBuildingException {
        StateflowDeclContainerBase<?> parent = this.determineParent(element);
        parent.addData(element);
    }

    private StateflowDeclContainerBase<?> determineParent(StateflowDeclBase element) throws SimulinkModelBuildingException {
        StateflowElementBase<?> relatedElement = this.getRelatedElementFromArrayParameter(element, "linkNode");
        if (!(relatedElement instanceof StateflowDeclContainerBase)) {
            throw new SimulinkModelBuildingException(String.valueOf(relatedElement) + " cannot be parent of " + String.valueOf(element));
        }
        return (StateflowDeclContainerBase)relatedElement;
    }

    private void buildTargetRelation(StateflowTarget element) throws SimulinkModelBuildingException {
        StateflowElementBase<?> relatedElement = this.getRelatedElementFromArrayParameter(element, "linkNode");
        StateflowMachine parent = this.castToMachine(relatedElement, element);
        parent.addTarget(element);
    }

    private void buildChartRelation(StateflowChart element) throws SimulinkModelBuildingException {
        StateflowElementBase<?> relatedElement = this.elements.get(element.getParameter("machine"));
        StateflowMachine parent = this.castToMachine(relatedElement, element);
        String fqName = this.model.getName() + "/" + element.getParameter("name");
        parent.addChart(fqName, element);
    }

    private StateflowMachine castToMachine(StateflowElementBase<?> machineElement, StateflowElementBase<?> element) throws SimulinkModelBuildingException {
        if (machineElement != this.model.getStateflowMachine()) {
            throw new SimulinkModelBuildingException(String.valueOf(element) + " must belong to machine " + String.valueOf(this.model.getStateflowMachine()));
        }
        return (StateflowMachine)machineElement;
    }

    private void buildTransition(MDLSection section) throws SimulinkModelBuildingException {
        String srcId = StateflowBuilder.getId(section, "src");
        String dstId = StateflowBuilder.getId(section, "dst");
        if (!this.preserveUnconnectedLines && srcId == null && dstId == null) {
            LOGGER.warn("Found null->null transition. Ignoring transition.");
        }
        if (!this.preserveUnconnectedLines && dstId == null) {
            LOGGER.warn("Found transition without destination. Ignoring transition.");
            return;
        }
        StateflowTransition transition = new StateflowTransition(this.getNode(srcId, section), this.getNode(dstId, section));
        StateflowBuilder.addParameters(section, transition);
        if (srcId == null && dstId == null) {
            StateflowElementBase<?> chart;
            String chartId = transition.getParameter("chart");
            String subviewer = transition.getParameter("subviewer");
            if (subviewer == null && chartId == null) {
                LOGGER.error("Missing chart id for unconnected transition. Ignoring the transition.");
                return;
            }
            if (subviewer != null && !subviewer.isEmpty()) {
                chartId = subviewer;
            }
            if ((chart = this.elements.get(chartId)) instanceof StateflowChart) {
                ((StateflowChart)chart).addUnconnectedTransition(transition);
            } else if (chart instanceof StateflowState) {
                CCSMAssert.isTrue((boolean)((StateflowState)chart).isSubChart(), (String)"StateflowChart is child of non-subchart StateflowState!");
                chart.getParentChart().addUnconnectedTransition(transition);
            } else {
                LOGGER.error("Chart id " + chartId + " for unconnected transition does not refer to a chart!");
            }
        }
        StateflowBuilder.copyIntersection(section, "src", transition);
        StateflowBuilder.copyIntersection(section, "dst", transition);
    }

    private static void copyIntersection(MDLSection section, String subSectionName, StateflowTransition transition) {
        MDLSection subSection = section.getFirstSubSection(subSectionName);
        if (subSection == null || !subSection.hasParameter("intersection")) {
            LOGGER.error("Missing intersection. Transition " + transition.getLabel() + " is missing a " + subSectionName + " intersection.");
            return;
        }
        transition.setParameter(subSectionName + "_intersection", subSection.getParameter("intersection"));
    }

    private static String getId(MDLSection section, String subSectionName) {
        MDLSection subSection = section.getFirstSubSection(subSectionName);
        if (subSection == null) {
            return null;
        }
        return subSection.getParameter("id");
    }

    private StateflowNodeBase getNode(String id, MDLSection section) throws SimulinkModelBuildingException {
        if (id == null) {
            return null;
        }
        StateflowElementBase<?> element = this.elements.get(id);
        if (element == null) {
            throw new SimulinkModelBuildingException("Stateflow element with id " + id + " not found.", section);
        }
        if (!(element instanceof StateflowNodeBase)) {
            throw new SimulinkModelBuildingException("Only Stateflow nodes can be source or destination of transitions.", section);
        }
        return (StateflowNodeBase)element;
    }
}

