/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder.file;

import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.file.ISimulinkFileContentProvider;

class OpcTextPackageFileContentProvider
implements ISimulinkFileContentProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    static final String PACKAGE_BEGIN = "__MWOPC_PACKAGE_BEGIN__";
    private static final String PART_BEGIN = "__MWOPC_PART_BEGIN__";
    private static final String PACKAGE_END = "__MWOPC_PACKAGE_END__";
    private static final Pattern PART_BEGIN_PATTERN = Pattern.compile("__MWOPC_PART_BEGIN__ +/([^ ]*)( +BASE64 *)?");
    private final Map<String, String> textContents = new HashMap<String, String>();
    private final Map<String, byte[]> binaryContents = new HashMap<String, byte[]>();

    public OpcTextPackageFileContentProvider(String content) {
        new OpcTextPackageParser().parse(content);
    }

    @Override
    public boolean isMultiFileContainer() {
        return true;
    }

    @Override
    public List<String> listContainedFilenames() {
        return CollectionUtils.sort((Collection)CollectionUtils.unionSet(this.textContents.keySet(), (Collection[])new Collection[]{this.binaryContents.keySet()}));
    }

    @Override
    public Optional<String> getNamedContent(String name) {
        return Optional.ofNullable(this.textContents.get(name));
    }

    @Override
    public Optional<byte[]> getNamedBinaryContent(String name) {
        return Optional.ofNullable(this.binaryContents.get(name));
    }

    private class OpcTextPackageParser {
        private boolean skipping = true;
        private final StringBuilder currentContent = new StringBuilder();
        private String currentFilename = "";
        private boolean currentIsBinary = false;

        private OpcTextPackageParser() {
        }

        public void parse(String content) {
            for (String line : StringUtils.splitLinesAsList((String)content)) {
                if (line.startsWith(OpcTextPackageFileContentProvider.PACKAGE_BEGIN)) {
                    this.skipping = false;
                    continue;
                }
                if (line.startsWith(OpcTextPackageFileContentProvider.PACKAGE_END)) {
                    this.completeCurrentFile();
                    return;
                }
                if (line.startsWith(OpcTextPackageFileContentProvider.PART_BEGIN)) {
                    this.completeCurrentFile();
                    this.skipping = false;
                    Matcher matcher = PART_BEGIN_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        LOGGER.error("Failed to parse part begin line: " + line);
                        this.skipping = true;
                        continue;
                    }
                    this.currentFilename = matcher.group(1);
                    this.currentContent.setLength(0);
                    this.currentIsBinary = matcher.group(2) != null;
                    continue;
                }
                if (this.skipping) continue;
                this.currentContent.append(line);
                if (this.currentIsBinary) continue;
                this.currentContent.append("\n");
            }
        }

        private void completeCurrentFile() {
            if (this.skipping) {
                return;
            }
            if (this.currentIsBinary) {
                try {
                    byte[] data = Base64.getDecoder().decode(this.currentContent.toString());
                    OpcTextPackageFileContentProvider.this.binaryContents.put(this.currentFilename, data);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Skipping invalid BASE64 content for file " + this.currentFilename + ": " + e.getMessage(), (Throwable)e);
                }
            } else {
                OpcTextPackageFileContentProvider.this.textContents.put(this.currentFilename, this.currentContent.toString());
            }
        }
    }
}

