/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler;

import java.util.Arrays;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.LabelLayoutData;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkBlockLabelUtils;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkPortLabelUtils;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
public enum ESimulinkBlockType {
    ACTION_PORT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.determineActionPortData(block);
        }
    }
    ,
    ALGEBRAIC_CONSTRAINT("Algebraic Constraint"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Solve\nf(z) = 0";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainAlgebraicConstraintPortData(port);
        }
    }
    ,
    ARG_IN,
    ARG_OUT,
    ARITH_SHIFT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainArithShiftData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainArithShiftPortData(port);
        }
    }
    ,
    ASSERTION{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainAssertionBlockIcon(block);
        }
    }
    ,
    ASSIGNMENT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainAssignmenOrSelectortBlockData(block, "Assignment");
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainAssignmentPortData(port);
        }
    }
    ,
    BAND_LIMITED_NOISE("Band-Limited White Noise."){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "noise.png";
        }
    }
    ,
    BIAS{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainBiasBlockData(block);
        }
    }
    ,
    BIT_CLEAR("Bit Clear"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainBitClearOrSetBlockData(block, "Clear");
        }
    }
    ,
    BIT_SET("Bit Set"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainBitClearOrSetBlockData(block, "Set");
        }
    }
    ,
    BITWISE_OPERATOR("Bitwise Operator"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainBitwiseOperatorBlockData(block);
        }
    }
    ,
    BUS_ASSIGNMENT{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBusAssignmentPortData(port);
        }
    }
    ,
    BUS_CREATOR,
    BUS_SELECTOR,
    CLOCK,
    COMPARE_TO_CONSTANT("Compare To Constant"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainCompareToConstantBlockData(block);
        }
    }
    ,
    COMPARE_TO_ZERO("Compare To Zero"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainCompareToZeroBlockData(block);
        }
    }
    ,
    COMPLEX_TO_MAGNITUDE_ANGLE{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainComplexToMagnitudeAngleBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainComplexBlocksIcons(block.getParameter("Output"), Arrays.asList(null, "complex_to_ma_angle.png", "complex_to_ma_both.png"));
        }
    }
    ,
    COMPLEX_TO_REAL_IMAG{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainComplexToRealImagBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainComplexBlocksIcons(block.getParameter("Output"), Arrays.asList("complex_to_ri_both.png"));
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainComplexToRealImagPortData(port);
        }
    }
    ,
    CONCATENATE{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainConcatenateIcon(block);
        }
    }
    ,
    CONSTANT,
    CONVERSION_INHERITED("Conversion Inherited"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Convert";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainConversionInheritedPortData(port);
        }
    }
    ,
    COUNTER_FREE_RUNNING("Counter Free-Running"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "counter_free_running.png";
        }
    }
    ,
    D_FLIP_FLOP("DFlipFlop"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFlipFlopPortData(port, Arrays.asList("D", "CLK", "!CLR"));
        }
    }
    ,
    D_LATCH("DLatch"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFlipFlopPortData(port, Arrays.asList("D", "C"));
        }
    }
    ,
    DATA_STORE_MEMORY,
    DATA_STORE_READ,
    DATA_STORE_WRITE,
    DATA_TYPE_CONVERSION{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDataTypeConversionBlockData(block);
        }
    }
    ,
    DATA_TYPE_DUPLICATE,
    DATA_TYPE_PROPAGATION("Data Type Propagation"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainDataTypePropagationPortData(port, "Data Type Propagation");
        }
    }
    ,
    DEAD_ZONE_DYNAMIC("Dead Zone Dynamic"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "dead_zone_dynamic.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("up", "u", "b"), Arrays.asList("y"));
        }
    }
    ,
    DELAY{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDelayData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainDelayBlockPortData(port);
        }
    }
    ,
    DEMUX{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainMuxBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainMuxBlockIcon(block);
        }
    }
    ,
    DETECT_CHANGE("Detect Change"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "U ~= U/z";
        }
    }
    ,
    DISCRETE_FILTER{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDiscreteFilterBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainDiscreteFilterPortData(port);
        }
    }
    ,
    DISCRETE_FIR{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDiscreteFirBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainDiscreteFirPortData(port);
        }
    }
    ,
    DISCRETE_PULSE_GENERATOR{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDiscretePulseGeneratorIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainDiscretePulseGeneratorPortData(port);
        }
    }
    ,
    DISCRETE_STATE_SPACE{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "discrete_state_space.png";
        }
    }
    ,
    DISCRETE_INTEGRATOR{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDiscreteIntegratorTextData(block);
        }
    }
    ,
    DISCRETE_ZERO_POLE{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDiscreteZeroPoleTextData(block);
        }
    }
    ,
    DISCRETE_TRANSFER_FCN{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainDiscreteTransferFcnBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainDiscreteFilterPortData(port);
        }
    }
    ,
    DISPLAY{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.getDisplayBlockFormat(block);
        }
    }
    ,
    ENABLE_PORT,
    ENUMERATED_CONSTANT("Enumerated Constant"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return block.getParameter("Value");
        }
    }
    ,
    EVENT_LISTENER{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            String eventType;
            switch (eventType = block.getParameter("EventType")) {
                case "Reset": {
                    return "event_listener_reset.png";
                }
                case "Terminate": {
                    return "event_listener_terminate.png";
                }
                case "Initialize": {
                    return "event_listener_initialize.png";
                }
            }
            return null;
        }
    }
    ,
    EXTRACT_BITS("Extract Bits"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainExtractBitsBlockData(block);
        }
    }
    ,
    FCN,
    FLIP_FLOP_DIGITAL_CLOCK("Digital clock"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "extras_digital_clock.png";
        }
    }
    ,
    FOR_ITERATOR{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainForIteratorPortData(port);
        }
    }
    ,
    FROM{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainGotoFromBlockLabel(block);
        }
    }
    ,
    FROM_WORKSPACE,
    FUNCTION_CALLER{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainFunctionCallerBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFunctionCallerPortData(port);
        }
    }
    ,
    FUNCTION_CALL_GENERATOR("Function-Call Generator"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainFunctionCallGeneratorBlockData(block);
        }
    }
    ,
    FUNCTION_CALL_SPLIT{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFunctionCallSplitPortLabelData(port);
        }
    }
    ,
    GOTO{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainGotoFromBlockLabel(block);
        }
    }
    ,
    GAIN{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainGainBlockData(block);
        }
    }
    ,
    GROUND,
    IF{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainIfPortLabelData(port);
        }
    }
    ,
    INPORT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.determineTextForPorts(block);
        }
    }
    ,
    INPORT_SHADOW{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.determineTextForPorts(block);
        }
    }
    ,
    INTEGRATOR{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainIntegratorBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainIntegratorPortData(port);
        }
    }
    ,
    INTERVAL_TEST_DYNAMIC("Interval Test Dynamic"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            String closedRight = block.getParameter("IntervalClosedRight");
            String closedLeft = block.getParameter("IntervalClosedLeft");
            if (closedRight.equals("on")) {
                if (closedLeft.equals("on")) {
                    return "interval_lc_rc.png";
                }
                return "interval_lo_rc.png";
            }
            if (closedLeft.equals("on")) {
                return "interval_lc_ro.png";
            }
            return "interval_lo_ro.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("up", "u", "lo"), Arrays.asList("y"));
        }
    }
    ,
    JK_FLIP_FLOP("JKFlipFlop"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFlipFlopPortData(port, Arrays.asList("J", "CLK", "K"));
        }
    }
    ,
    LOGIC{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainLogicBlockTextLabel(block);
        }
    }
    ,
    LOOKUP_N_D_DIRECT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainLookupNDBlockcData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainNDLookupBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainLookupNDPortData(port);
        }
    }
    ,
    LOOKUP_TABLE_DYNAMIC("Lookup Table Dynamic"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainLookupTableDynamicPortData(port);
        }
    }
    ,
    MAGNITUDE_ANGLE_TO_COMPLEX{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainComplexBlocksIcons(block.getParameter("Input"), Arrays.asList("ma_to_complex_magnitude.png", "ma_to_complex_angle.png", "ma_to_complex_both.png"));
        }
    }
    ,
    MANUAL_SWITCH{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainManualSwitchIcon(block);
        }
    }
    ,
    MATH{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainMathBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainMathBlockIcon(block);
        }
    }
    ,
    MERGE,
    MIN_MAX_RUNNING_RESETTABLE("MinMax Running Resettable"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainMinMaxResettableBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainMinMaxResettablePortData(port);
        }
    }
    ,
    MODEL_REFERENCE,
    MULTI_PORT_SWITCH("MultiPortSwitch"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainMultiPortSwitchPortData(port);
        }
    }
    ,
    MUX{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainMuxBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainMuxBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainMuxPortData(port);
        }
    }
    ,
    OUTPORT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.determineTextForPorts(block);
        }
    }
    ,
    PERMUTE_DIMENSIONS{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainPermuteDimensionsBlockData(block);
        }
    }
    ,
    PRE_LOOKUP{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainPreLookupBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainPreLookupPortData(port);
        }
    }
    ,
    PRODUCT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainProductData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainProductBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainProductPortData(port);
        }
    }
    ,
    RAMP("Ramp"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "ramp.png";
        }
    }
    ,
    RATE_TRANSITION,
    REAL_IMAG_TO_COMPLEX{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainRealImagToComplexBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainComplexBlocksIcons(block.getParameter("Input"), Arrays.asList("ri_to_complex_both.png"));
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainRealImagToComplexPortData(port);
        }
    }
    ,
    REFERENCE{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainReferenceBlockLabelData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainReferenceBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainReferencePortData(port);
        }
    }
    ,
    RELATIONAL_OPERATOR,
    RESET_PORT{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainResetPortBlockIcon(block);
        }
    }
    ,
    RESHAPE{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainReshapeBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainReshapeBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainReshapePortData(port);
        }
    }
    ,
    SAMPLE_TIME_MATH{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainSampleTimeMathBlockData(block);
        }
    }
    ,
    SATURATION_DYNAMIC("Saturation Dynamic"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "saturation_dynamic.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("up", "u", "b"), Arrays.asList("y"));
        }
    }
    ,
    SCALING_STRIP("Scaling Strip"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Scaling Strip".replaceAll("\\s", "\n");
        }
    }
    ,
    SELECTOR{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainAssignmenOrSelectortBlockData(block, "Selector");
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainSelectorPortData(port);
        }
    }
    ,
    SIGNAL_CONVERSION{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainSignalConversionData(block);
        }
    }
    ,
    SIGNAL_SPECIFICATION{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainSignalSpecificationData(block);
        }
    }
    ,
    SIN{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainSinPortData(port);
        }
    }
    ,
    SLIDER_GAIN("Slider Gain"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return block.getParameter("Gain".toLowerCase());
        }
    }
    ,
    SQRT{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainSqrtBlockIcon(block);
        }
    }
    ,
    SR_FLIP_FLOP("SRFlipFlop"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFlipFlopPortData(port, Arrays.asList("S", "R", "i"));
        }
    }
    ,
    STATE_READER{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainStateReaderWriterBlockData(block);
        }
    }
    ,
    STATE_WRITER{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainStateReaderWriterBlockData(block);
        }
    }
    ,
    STEP{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainStepBlockIcon(block);
        }
    }
    ,
    STRING_FIND{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainStringFindLabelData(port);
        }
    }
    ,
    SUB_SYSTEM{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.getSubSystemBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.getSubSystemBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainSubSystemPortLabelData(port);
        }
    }
    ,
    SUM{

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainSumBlockIcon(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainRectangularSumInPortLabelData(port);
        }
    }
    ,
    SUM_ROUND{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainSumInPortLabelData(port);
        }
    }
    ,
    SWITCH{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.determineTextForSwitch(block);
        }
    }
    ,
    SWITCH_CASE{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainSwitchCasePortLabelData(port);
        }
    }
    ,
    TERMINATOR,
    TRIGGER_PORT{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainTriggerPortBlockData(block);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainTriggerPortBlockIcon(block);
        }
    }
    ,
    UNIT_DELAY,
    WHILE_ITERATOR{

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.getWhileIteratorBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainWhileIteratorPortData(port);
        }
    }
    ,
    VARIANT_SINK{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainVariantSinkPortData(port);
        }
    }
    ,
    VARIANT_SOURCE{

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainVariantSourcePortData(port);
        }
    }
    ,
    BACE_ARRAY_MIN_MAX("MinMax"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return block.getParameter("MinMax".toLowerCase());
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceArrayMinMaxPortData(port);
        }
    }
    ,
    BACE_BIT_SHIFT("BACE_BitShift/BitShift"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceBitShiftPortData(port);
        }
    }
    ,
    BACE_BITWISE_NOT("Bitwise NOT with bitmask"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Bitwise\nNOT";
        }
    }
    ,
    BACE_BMW_FUNCTION_CALL_GENERATOR("BMW_FunctionCallGenerator"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainBmwFunctionCallGeneratorBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBmwFunctionCallGeneratorPortData(port);
        }
    }
    ,
    BACE_CERTIFIED_SUBSYSTEM("BACE_CertifiedSubsystem"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Not OK";
        }
    }
    ,
    BACE_CLOSED_INTERVAL("BACE_ClosedInterval"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "A<=X<=C";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("A", "X", "C"), Arrays.asList("==>"));
        }
    }
    ,
    BACE_COUNT_DOWN("CountDownResetEnabled"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_countdown.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceCounterPortData(port);
        }
    }
    ,
    BACE_COUNTER("CounterResetEnabled"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_counter.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceCounterPortData(port);
        }
    }
    ,
    BACE_DIV_BY_ZERO("BACE DivBy0Prot"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainBaceDivByZeroBlockData(block);
        }
    }
    ,
    BACE_DT("BACE_Mask_dt"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "dt";
        }
    }
    ,
    BACE_EDGE_BI("Edge_Bi"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_edge_bi.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceEdgePortData(port);
        }
    }
    ,
    BACE_EDGE_FALLING("Edge_Falling"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_edge_falling.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceEdgePortData(port);
        }
    }
    ,
    BACE_EDGE_RISING("Edge_Rising"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_edge_rising.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceEdgePortData(port);
        }
    }
    ,
    BACE_GAIN("BACE_Fixpoint_Gain"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return SimulinkBlockLabelUtils.obtainGainBlockData(block);
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFixPointPortLabel(port);
        }
    }
    ,
    BACE_FADER("BACE Fader"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_fader.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("In1", "In0", "F"), Arrays.asList("Out"));
        }
    }
    ,
    BACE_FADER_CONST("BACE Fader with Constant Parameter"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_fader_const.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("In1", "In0", "F"), Arrays.asList("Out"));
        }
    }
    ,
    BACE_FALSE_CONSTANT("false_mask"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "false");
        }
    }
    ,
    BACE_FEEDBACK_LATCH("BACE_FeedbackLatch"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Feedback\nLatch";
        }
    }
    ,
    BACE_FIXED_STEP_DELAY("BACE_FixedStepDelay"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_fixed_variable_delay.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceFixedVariableDelayPortData(port);
        }
    }
    ,
    BACE_FIXED_MOVING_AVERAGE("FixedMovingAverage"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceMovingAveragePortData(port, "FixedMovingAverage");
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_moving_average.png";
        }
    }
    ,
    BACE_FIXPOINT_PRODUCT("BACE_Fixpoint_Product/Safe Fixpoint Product"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFixPointPortLabel(port);
        }
    }
    ,
    BACE_HYSTERESIS("Hysteresis_LSP_RSP"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_hysteresis.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceHysteresisPortData(port);
        }
    }
    ,
    BACE_IF_THEN("If Then"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceIfThenPortData(port);
        }
    }
    ,
    BACE_IS_FLOAT("BACE_is_float"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "is float?";
        }
    }
    ,
    BACE_LOWPASS_CONST("BACE LowPass with Constant Parameters (safe)"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_lowpass_filter.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceLowPassConstPortData(port);
        }
    }
    ,
    BACE_LOWPASS_CONST_IV("BACE_LowPass_constIV"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_lowpass_filter.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceLowPassPortData(port);
        }
    }
    ,
    BACE_LOWPASS_CONSTK_IV("BACE LowPass with Constant Parameters  and initial value (safe)"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_lowpass_filter.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceLowPassConstPortData(port);
        }
    }
    ,
    BACE_LOWPASS_IV("BACE LowPass_IV"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_lowpass_filter.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceLowPassPortData(port);
        }
    }
    ,
    BACE_LOWPASS_IV_EXTERNAL("BACE LowPass (unsafe) external"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_lowpass_filter.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceLowPassPortData(port);
        }
    }
    ,
    BACE_MATLAB_FUNCTION("BACELib_Userdefined/MATLAB Function"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceMatlabFnPortData(port);
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "matlab_fn.png";
        }
    }
    ,
    BACE_MIN_MAX_EPSILON("Datatype MinMaxEpsilon"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return block.getParameter("mmV").toUpperCase().substring(0, 3);
        }
    }
    ,
    BACE_RAMPE("rampe timebased"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Rampe\n[1/s]";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("IN1", "IN2", "INIT_C", "INIT_V", "RAMP2IN1", "RAMP", "i"), Arrays.asList("OUT"));
        }
    }
    ,
    BACE_RATE_LIMITER("BACE_RateLimiter"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_rate_limiter.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("grdUP", "U", "grdDN", "U_ini", "ini_cdn"), Arrays.asList("Y"));
        }
    }
    ,
    BACE_SAFE_FLOAT_COMPARE("safe_float_compare"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return block.getParameter("Operator".toLowerCase());
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceSafeFloatComparePortData(port);
        }
    }
    ,
    BACE_SIGNAL_CHANGE_DETECTOR("BACE SignalChangeDetector"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Signal Change";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.extractPortLabelForBlockPort(port, Arrays.asList("u", "i"), Arrays.asList("y"));
        }
    }
    ,
    BACE_SR_FLIP_FLOP("BACE_SR_FlipFlop"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return block.getParameter("dominance") + "\ndominant";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainFlipFlopPortData(port, Arrays.asList("S", "R", "i"));
        }
    }
    ,
    BACE_STATIC_ASSERTION("BACE_StaticAssertion"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "assert";
        }
    }
    ,
    BACE_TIMER("TimerResetEnabled"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_timer.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceTimerPortData(port);
        }
    }
    ,
    BACE_TIMER_RETRIGGER("TimerRetriggerResetEnabled"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_timer_retrigger.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceTimerPortData(port);
        }
    }
    ,
    BACE_TRUE_CONSTANT("true_mask"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.positionPortLabel(port, "true");
        }
    }
    ,
    BACE_TWICE_BITS_CONVERTER("Twice Bits Same Range Converter"){

        @Override
        public String getBlockTextLabel(SimulinkBlock block) {
            return "Twice Bits\nSame Range";
        }
    }
    ,
    BACE_VARIABLE_INPUT_DELAY("VariableInputDelay"){

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_fixed_variable_delay.png";
        }

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceFixedVariableDelayPortData(port);
        }
    }
    ,
    BACE_VARIABLE_MOVING_AVERAGE("variable moving average"){

        @Override
        public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
            return SimulinkPortLabelUtils.obtainBaceMovingAveragePortData(port, "variable moving average");
        }

        @Override
        public String getBlockIconLabel(SimulinkBlock block) {
            return "bace_moving_average.png";
        }
    }
    ,
    DEFAULT;

    private @Nullable String sourceType;

    public String getBlockTextLabel(SimulinkBlock block) {
        return null;
    }

    public String getBlockIconLabel(SimulinkBlock block) {
        return null;
    }

    public LabelLayoutData getBlockPortLabels(SimulinkPortBase port) {
        return null;
    }

    private ESimulinkBlockType() {
        this.sourceType = null;
    }

    private ESimulinkBlockType(String sourceType) {
        this.sourceType = sourceType;
    }

    public static ESimulinkBlockType getReferenceBlockEnumType(String sourceTypeValue, String sourceBlockValue) {
        for (ESimulinkBlockType blockType : ESimulinkBlockType.values()) {
            String blockSourceType = blockType.sourceType;
            if (blockSourceType == null || !blockSourceType.equals(sourceTypeValue) && !blockSourceType.equals(sourceBlockValue) || !sourceBlockValue.startsWith("simulink/")) continue;
            return blockType;
        }
        return REFERENCE;
    }
}

