/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.simulink.builder.SimulinkBus;
import org.conqat.lib.simulink.builder.SimulinkBusElement;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

public final class SimulinkBusUtils {
    public static boolean isBusElementPort(SimulinkBlock block) {
        return (SimulinkUtils.isInport(block) || SimulinkUtils.isOutport(block)) && block.getParameter("InterfaceData.PortName") != null && block.getParameter("InterfaceData.PortNumber") != null;
    }

    public static Optional<SimulinkBusElement> determineBusElement(String busElementPath, SimulinkBus inputBus, List<SimulinkDataDictionary> dictionaries) {
        List busElementPathParts = StringUtils.splitToList((String)busElementPath, (String)"\\.");
        SimulinkBus currentBus = inputBus;
        Optional<SimulinkBusElement> currentBusElement = Optional.empty();
        for (int i = 0; i < busElementPathParts.size(); ++i) {
            String part = (String)busElementPathParts.get(i);
            currentBusElement = currentBus.getBusElements().stream().filter(el -> el.getName().equals(part)).findAny();
            if (i == busElementPathParts.size() - 1 || currentBusElement.isEmpty()) continue;
            String busName = StringUtils.stripPrefix((String)currentBusElement.get().getDataType(), (String)"Bus: ");
            Optional<SimulinkBus> potentialNextBus = SimulinkUtils.findDataDictionaryEntry(dictionaries, busName, SimulinkBus.class);
            if (potentialNextBus.isEmpty()) {
                return Optional.empty();
            }
            currentBus = potentialNextBus.get();
        }
        return currentBusElement;
    }

    public static List<Optional<SimulinkBusElement>> determineAllBusElementsInOutputSignals(SimulinkBlock block, String inputDataType, List<SimulinkDataDictionary> dictionaries) {
        if (inputDataType == null || !StringUtils.startsWithIgnoreCase((String)inputDataType, (String)"Bus: ")) {
            return Collections.emptyList();
        }
        String busName = StringUtils.stripPrefix((String)inputDataType, (String)"Bus: ");
        Optional<SimulinkBus> potentialInputBus = SimulinkUtils.findDataDictionaryEntry(dictionaries, busName, SimulinkBus.class);
        if (potentialInputBus.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Optional<SimulinkBusElement>> busElements = new ArrayList<Optional<SimulinkBusElement>>();
        for (String busElementName : SimulinkBusUtils.getOutputSignalNames(block)) {
            Optional<SimulinkBusElement> busElement = SimulinkBusUtils.determineBusElement(busElementName, potentialInputBus.get(), dictionaries);
            busElements.add(busElement);
        }
        return busElements;
    }

    public static List<String> getOutputSignalNames(SimulinkBlock block) {
        String outputSignals = block.getParameter("OutputSignals");
        return StringUtils.splitToList((String)outputSignals, (String)",");
    }

    private SimulinkBusUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

