/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.transaction;

import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.persistence.cache.StorageCacheProvider;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemBase;
import org.conqat.engine.persistence.store.transaction.TransactionalStore;
import org.conqat.lib.commons.factory.IFactory;

public class TransactionalStorageSystem
extends DelegatingStorageSystemBase {
    private final Map<String, TransactionalStore> openStores = new HashMap<String, TransactionalStore>();
    private final StorageCacheProvider.StorageSystemCacheProvider cacheProvider;
    private final IFactory<IStore, StorageException> tempStoreCreator;

    public TransactionalStorageSystem(IStorageSystem delegateStorageSystem, StorageCacheProvider.StorageSystemCacheProvider cacheProvider, IFactory<IStore, StorageException> tempStoreCreator) {
        super(delegateStorageSystem);
        this.cacheProvider = cacheProvider;
        this.tempStoreCreator = tempStoreCreator;
    }

    @Override
    public synchronized IStore openStore(String name) throws StorageException {
        TransactionalStore store = this.openStores.get(name);
        if (store == null) {
            store = new TransactionalStore(super.openStore(name), this.tempStoreCreator);
            this.openStores.put(name, store);
        }
        return store;
    }

    public synchronized void commit() throws StorageException {
        for (TransactionalStore store : this.openStores.values()) {
            store.commit();
        }
        this.cacheProvider.invalidateCaches();
    }

    public synchronized void rollback() throws StorageException {
        for (TransactionalStore store : this.openStores.values()) {
            store.rollback();
        }
    }
}

