/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.conqat.engine.persistence.config.DatabaseConfiguration;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;

public class StoreFactory
implements IFactory<IStore, StorageException> {
    private static final String TEMPORARY_STORAGE_SYSTEM_PROPERTY = "com.teamscale.persistence.temporary-storage-system-type";
    private static final String BASE_NAME = "store";
    private final IStorageSystem storageSystem;
    private int counter = 0;

    private StoreFactory(IStorageSystem storageSystem) {
        this.storageSystem = storageSystem;
    }

    public IStore create() throws StorageException {
        return this.storageSystem.openStore(this.createStoreName());
    }

    private synchronized String createStoreName() {
        return BASE_NAME + this.counter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X extends Exception> void runWithTemporaryOnDiskStoreFactory(ConsumerWithException<StoreFactory, X> runnable, File temporaryStorageDirectory, DatabaseConfiguration databaseConfiguration) throws X, StorageException, IOException {
        try (IStorageSystemProvider temporaryStorageSystemProvider = StoreFactory.createTemporaryStorageSystem(temporaryStorageDirectory, databaseConfiguration);){
            runnable.accept((Object)new StoreFactory(temporaryStorageSystemProvider.openStorageSystem("temp")));
        }
        finally {
            FileSystemUtils.deleteRecursively((File)temporaryStorageDirectory);
        }
    }

    private static IStorageSystemProvider createTemporaryStorageSystem(File temporaryStorageDirectory, DatabaseConfiguration databaseConfiguration) throws StorageException {
        DatabaseConfiguration configuration = databaseConfiguration.withTemporaryStore(temporaryStorageDirectory);
        String storageSystemType = System.getProperty(TEMPORARY_STORAGE_SYSTEM_PROPERTY);
        if (!StringUtils.isEmpty((String)storageSystemType)) {
            configuration = configuration.withDatabaseType(DatabaseConfiguration.EDatabaseType.of(storageSystemType));
        }
        return configuration.createStorageSystemProvider(1);
    }

    public static File createTemporaryStorageDirectory(File baseDirectory, String prefix) throws IOException {
        FileSystemUtils.ensureDirectoryExists((File)baseDirectory);
        File temporaryStorageDirectory = Files.createTempDirectory(baseDirectory.toPath(), prefix, new FileAttribute[0]).toFile();
        FileSystemUtils.ensureDirectoryExists((File)temporaryStorageDirectory);
        return temporaryStorageDirectory;
    }
}

