/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.classes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.conqat.lib.commons.serialization.SerializationConsistencyException;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;

public abstract class SerializedComplexFieldBase
extends SerializedFieldBase {
    private final String detailedType;

    protected SerializedComplexFieldBase(String fieldName, SerializedEntityParser parser) throws IOException {
        super(fieldName);
        this.detailedType = parser == null ? null : parser.parseStringObject().getValue();
    }

    protected SerializedComplexFieldBase(String fieldName, String detailedType) {
        super(fieldName);
        this.detailedType = detailedType;
    }

    public String getDetailedType() {
        return this.detailedType;
    }

    @Override
    public void serialize(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        super.serialize(dos, serializer);
        serializer.serializeStringObject(this.detailedType);
    }

    @Override
    public Object readValue(DataInputStream din, SerializedEntityParser parser) throws IOException {
        return parser.parseContent();
    }

    @Override
    public void writeValue(Object value, SerializedEntityPool pool, DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        if (!(value instanceof Integer)) {
            throw new SerializationConsistencyException("Expected a handle as value for field " + this.getName());
        }
        int handle = (Integer)value;
        SerializedEntitySerializer.serializeObject(handle, SerializedObjectBase.class, pool, dos, serializer);
    }
}

