/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedComplexFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.objects.SerializedArrayObject;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedEnumLiteral;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class SerializationMigrationUtils {
    public static void transformStringsInHashSet(SerializedObject setObject, Function<String, String> transformation, SerializedEntityPool pool) throws IOException {
        SerializedClass setClass = SerializationMigrationUtils.findClassInHierarchy(setObject, HashSet.class);
        SerializedClassValues fieldSets = setObject.getFieldSet(setObject.getPlainClassHierarchy().indexOf(setClass));
        for (Object data : fieldSets.getPreFieldData()) {
            SerializedEntityBase containedElement;
            if (!(data instanceof Integer) || !((containedElement = pool.getEntity((Integer)data, SerializedEntityBase.class)) instanceof SerializedStringObject)) continue;
            SerializedStringObject stringContent = (SerializedStringObject)containedElement;
            stringContent.setValue((String)transformation.apply((Object)stringContent.getValue()));
        }
    }

    public static <T extends SerializedObjectBase> List<T> getObjectsFromArrayList(SerializedObject listObject, SerializedEntityPool pool) throws IOException {
        SerializedClass listClass = SerializationMigrationUtils.findClassInHierarchy(listObject, ArrayList.class);
        SerializedClassValues fieldSets = listObject.getFieldSet(listObject.getPlainClassHierarchy().indexOf(listClass));
        ArrayList<SerializedObjectBase> objects = new ArrayList<SerializedObjectBase>();
        for (Object data : fieldSets.getPostFieldData()) {
            if (!(data instanceof Integer)) continue;
            SerializedEntityBase containedElement = pool.getEntity((Integer)data, SerializedEntityBase.class);
            objects.add((SerializedObjectBase)containedElement);
        }
        return objects;
    }

    public static SerializedClass findClassInHierarchy(SerializedObject setObject, Class<?> classToFind) throws IOException {
        for (SerializedClass classObject : setObject.getPlainClassHierarchy()) {
            if (!classToFind.getName().equals(classObject.getName())) continue;
            return classObject;
        }
        CCSMAssert.fail("Only works on " + classToFind.getName() + " objects!");
        return null;
    }

    public static <T> T serializeRootEntities(SerializedEntityPool entityPool) throws AssertionError, IOException, ClassNotFoundException {
        List<SerializedEntityBase> rootEntities = entityPool.getRootEntities();
        byte[] newValue = SerializedEntitySerializer.serializeToBytes(rootEntities);
        return (T)SerializationUtils.deserializeFromByteArray(newValue);
    }

    public static SerializedObject createSerializedArrayListObject(List<SerializedObjectBase> entries, SerializedEntityPool entityPool) throws IOException {
        ArrayList arrayList = entries.stream().map(WrappedHandle::of).collect(Collectors.toCollection(ArrayList::new));
        byte[] bytes = SerializationUtils.serializeToByteArray(arrayList);
        SerializedEntityPool temporaryPool = SerializedEntityParser.parse(bytes);
        return SerializationMigrationUtils.copy(temporaryPool, (SerializedObject)Iterables.getOnlyElement(temporaryPool.getRootEntities(SerializedObject.class)), entityPool);
    }

    public static SerializedEntityBase createSerializedHashSet(HashSet<String> hashSet, SerializedEntityPool entityPool) throws IOException {
        SerializedEntityPool temporaryPool = SerializedEntityParser.parse(SerializationUtils.serializeToByteArray(hashSet));
        SerializedEntityBase serializedHashSet = (SerializedEntityBase)Iterables.getOnlyElement(temporaryPool.getRootEntities());
        return SerializationMigrationUtils.copy(temporaryPool, serializedHashSet, entityPool);
    }

    public static Serializable reconstructSerializable(SerializedEntityBase serializedEntity) throws IOException, ClassNotFoundException {
        byte[] bytes = SerializedEntitySerializer.serializeToBytes(List.of(serializedEntity));
        return SerializationUtils.deserializeFromByteArray(bytes);
    }

    public static SerializedEntityBase copy(SerializedEntityPool sourcePool, SerializedEntityBase sourceEntity, SerializedEntityPool targetPool) throws IOException {
        if (WrappedHandle.isWrappedHandle(sourceEntity)) {
            return WrappedHandle.unwrap((SerializedObject)sourceEntity, targetPool);
        }
        if (sourceEntity instanceof SerializedObject) {
            SerializedObject sourceObject = (SerializedObject)sourceEntity;
            return SerializationMigrationUtils.copy(sourcePool, sourceObject, targetPool);
        }
        if (sourceEntity instanceof SerializedStringObject) {
            SerializedStringObject sourceString = (SerializedStringObject)sourceEntity;
            String sourceStringValue = sourceString.getValue();
            return new SerializedStringObject(sourceStringValue, targetPool);
        }
        if (sourceEntity instanceof SerializedEnumLiteral) {
            SerializedEnumLiteral sourceEnum = (SerializedEnumLiteral)sourceEntity;
            return SerializationMigrationUtils.copy(sourcePool, sourceEnum, targetPool);
        }
        if (sourceEntity instanceof SerializedArrayObject) {
            SerializedArrayObject sourceArray = (SerializedArrayObject)sourceEntity;
            return SerializationMigrationUtils.copy(sourcePool, sourceArray, targetPool);
        }
        if (sourceEntity instanceof SerializedClass) {
            SerializedClass sourceClass = (SerializedClass)sourceEntity;
            return SerializationMigrationUtils.copy(sourcePool, sourceClass, targetPool);
        }
        throw new UnsupportedOperationException("Unsupported entity kind: " + String.valueOf(sourceEntity.getClass()));
    }

    private static SerializedObject copy(SerializedEntityPool sourcePool, SerializedObject sourceObject, SerializedEntityPool targetPool) throws IOException {
        SerializedClass sourceClass = sourceObject.getSerializedClass();
        List<SerializedClass> sourceClassHierarchy = sourceObject.getPlainClassHierarchy();
        if (sourceClassHierarchy.size() != sourceObject.getFieldSetCount()) {
            throw new UnsupportedOperationException("We assume that every non-Object superclass contributes a field set");
        }
        ArrayList<SerializedClassValues> targetFieldSets = new ArrayList<SerializedClassValues>(sourceObject.getFieldSetCount());
        for (int i = 0; i < sourceObject.getFieldSetCount(); ++i) {
            targetFieldSets.add(SerializationMigrationUtils.copyFieldSet(sourcePool, sourceClassHierarchy.get(i), sourceObject.getFieldSet(i), targetPool));
        }
        SerializedClass targetClass = SerializationMigrationUtils.copy(sourcePool, sourceClass, targetPool);
        int targetClassHandle = targetClass.getHandle();
        return new SerializedObject(targetClassHandle, targetFieldSets, targetPool);
    }

    private static SerializedEnumLiteral copy(SerializedEntityPool sourcePool, SerializedEnumLiteral sourceEnumLiteral, SerializedEntityPool targetPool) throws IOException {
        SerializedClass sourceEnumClass = sourceEnumLiteral.getSerializedClass();
        SerializedClass targetEnumClass = SerializationMigrationUtils.copy(sourcePool, sourceEnumClass, targetPool);
        return new SerializedEnumLiteral(targetPool, targetEnumClass.getHandle(), sourceEnumLiteral.getLiteralName());
    }

    private static SerializedArrayObject copy(SerializedEntityPool sourcePool, SerializedArrayObject sourceArrayObject, SerializedEntityPool targetPool) throws IOException {
        SerializedFieldBase elementType = sourceArrayObject.getElementType();
        SerializedClass sourceArrayClass = sourceArrayObject.getSerializedClass();
        SerializedClass targetClass = SerializationMigrationUtils.copy(sourcePool, sourceArrayClass, targetPool);
        SerializedArrayObject targetArrayObject = new SerializedArrayObject(targetPool, targetClass.getHandle(), elementType);
        for (int i = 0; i < sourceArrayObject.size(); ++i) {
            if (elementType instanceof SerializedComplexFieldBase) {
                int sourceElementHandle = (Integer)sourceArrayObject.getValue(i);
                int targetElementHandle = SerializationMigrationUtils.copyHandle(sourcePool, sourceElementHandle, targetPool);
                targetArrayObject.addValue(targetElementHandle);
                continue;
            }
            Object sourceElementValue = sourceArrayObject.getValue(i);
            targetArrayObject.addValue(sourceElementValue);
        }
        return targetArrayObject;
    }

    private static SerializedClass copy(SerializedEntityPool sourcePool, SerializedClass sourceClass, SerializedEntityPool targetPool) throws IOException {
        SerializedClass targetClass = targetPool.findClass(sourceClass.getName());
        if (targetClass != null) {
            return targetClass;
        }
        targetClass = new SerializedClass(sourceClass.getName(), sourceClass.getSerialVersionUid(), sourceClass.getClassDescriptionFlags(), targetPool);
        SerializedClass sourceSuperClass = sourcePool.getEntity(sourceClass.getSuperClassHandle(), SerializedClass.class);
        if (sourceSuperClass != null) {
            SerializedClass targetSuperClass = SerializationMigrationUtils.copy(sourcePool, sourceSuperClass, targetPool);
            targetClass.setSuperClassHandle(targetSuperClass.getHandle());
        }
        for (SerializedFieldBase sourceClassField : sourceClass.getFields()) {
            targetClass.addField(sourceClassField);
        }
        return targetClass;
    }

    private static SerializedClassValues copyFieldSet(SerializedEntityPool sourcePool, SerializedClass sourceClass, SerializedClassValues sourceFieldSet, SerializedEntityPool targetPool) throws IOException {
        UnmodifiableList<SerializedFieldBase> sourceClassFields = sourceClass.getFields();
        if (sourceClassFields.size() != sourceFieldSet.getSize()) {
            throw new UnsupportedOperationException("We assume that every field is represented in the field set");
        }
        SerializedClassValues targetFieldSet = new SerializedClassValues(sourceFieldSet.getSize());
        SerializationMigrationUtils.appendData(sourcePool, sourceFieldSet, true, targetPool, targetFieldSet);
        for (int i = 0; i < sourceFieldSet.getSize(); ++i) {
            SerializedFieldBase sourceClassField = (SerializedFieldBase)sourceClassFields.get(i);
            if (sourceClassField instanceof SerializedComplexFieldBase) {
                int sourceFieldValueHandle = (Integer)sourceFieldSet.getValue(i);
                int targetFieldValueHandle = SerializationMigrationUtils.copyHandle(sourcePool, sourceFieldValueHandle, targetPool);
                targetFieldSet.setValue(i, targetFieldValueHandle);
                continue;
            }
            Object sourceFieldValue = sourceFieldSet.getValue(i);
            targetFieldSet.setValue(i, sourceFieldValue);
        }
        SerializationMigrationUtils.appendData(sourcePool, sourceFieldSet, false, targetPool, targetFieldSet);
        return targetFieldSet;
    }

    private static void appendData(SerializedEntityPool sourcePool, SerializedClassValues sourceClassValues, boolean isPreFields, SerializedEntityPool targetPool, SerializedClassValues targetClassValues) throws IOException, UnsupportedOperationException {
        List<Object> sourceFieldData = SerializationMigrationUtils.getFieldData(sourceClassValues, isPreFields);
        if (sourceFieldData == null) {
            return;
        }
        for (Object sourceFieldDatum : sourceFieldData) {
            if (sourceFieldDatum instanceof Integer) {
                Integer referencedSourceObjectHandle = (Integer)sourceFieldDatum;
                int referencedTargetObjectHandle = SerializationMigrationUtils.copyHandle(sourcePool, referencedSourceObjectHandle, targetPool);
                targetClassValues.appendData(referencedTargetObjectHandle, isPreFields);
                continue;
            }
            if (sourceFieldDatum instanceof byte[]) {
                byte[] rawSourceData = (byte[])sourceFieldDatum;
                targetClassValues.appendData(rawSourceData, isPreFields);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported field datum kind: " + String.valueOf(sourceFieldDatum.getClass()));
        }
    }

    private static int copyHandle(SerializedEntityPool sourcePool, int sourceHandle, SerializedEntityPool targetPool) throws IOException {
        if (sourceHandle == 0) {
            return 0;
        }
        SerializedObjectBase sourceObject = sourcePool.getEntity(sourceHandle, SerializedObjectBase.class);
        SerializedEntityBase targetObject = SerializationMigrationUtils.copy(sourcePool, sourceObject, targetPool);
        return targetObject.getHandle();
    }

    private static @Nullable List<Object> getFieldData(SerializedClassValues classValues, boolean isPreFields) {
        if (isPreFields) {
            return classValues.getPreFieldData();
        }
        return classValues.getPostFieldData();
    }

    private SerializationMigrationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static class WrappedHandle
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int handle;

        private WrappedHandle(int handle) {
            this.handle = handle;
        }

        public static WrappedHandle of(SerializedObjectBase wrappedObject) {
            return new WrappedHandle(wrappedObject.getHandle());
        }

        private static SerializedObjectBase unwrap(SerializedObject serializedWrapper, SerializedEntityPool entityPool) throws IOException {
            int wrappedHandle = (Integer)serializedWrapper.getFieldValue("handle");
            return entityPool.getEntity(wrappedHandle, SerializedObjectBase.class);
        }

        public static boolean isWrappedHandle(SerializedEntityBase serializedEntity) throws IOException {
            if (!(serializedEntity instanceof SerializedObject)) {
                return false;
            }
            SerializedObject serializedObject = (SerializedObject)serializedEntity;
            SerializedClass serializedClass = serializedObject.getSerializedClass();
            return serializedClass.getName().equals(WrappedHandle.class.getName());
        }
    }
}

