/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class LongSummaryStatisticsHolder
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private LongSummaryStatistics statistics;

    public LongSummaryStatisticsHolder() {
        this(new LongSummaryStatistics());
    }

    public LongSummaryStatisticsHolder(LongSummaryStatistics statistics) {
        this.statistics = Objects.requireNonNull(statistics, "statistics");
    }

    public LongSummaryStatistics getStatistics() {
        return this.statistics;
    }

    public void update(int value) {
        this.statistics.accept(value);
    }

    public void update(long value) {
        this.statistics.accept(value);
    }

    public void merge(LongSummaryStatisticsHolder other) {
        this.merge(other.statistics);
    }

    public void merge(LongSummaryStatistics other) {
        this.statistics.combine(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        long count = this.statistics.getCount();
        out.writeLong(count);
        if (count > 0L) {
            out.writeLong(this.statistics.getMin());
            out.writeLong(this.statistics.getMax());
            out.writeLong(this.statistics.getSum());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        long count = in.readLong();
        if (count == 0L) {
            this.statistics = new LongSummaryStatistics();
        } else {
            long min = in.readLong();
            long max = in.readLong();
            long sum = in.readLong();
            this.statistics = new LongSummaryStatistics(count, min, max, sum);
        }
    }

    public String toString() {
        return this.statistics.toString();
    }
}

