/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service.client;

import com.teamscale.commons.service.EMimeType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;

public interface ISerializationFormat<T> {
    public Optional<EMimeType> getMimeType();

    public String serialize(T var1);

    default public HttpEntity toHttpEntity(T data) {
        return new StringEntity(this.serialize(data), StandardCharsets.UTF_8);
    }

    public static ISerializationFormat<List<NameValuePair>> toUrlEncodedFormData() {
        return new ISerializationFormat<List<NameValuePair>>(){

            @Override
            public Optional<EMimeType> getMimeType() {
                return Optional.of(EMimeType.URL_ENCODED_FORM_DATA);
            }

            @Override
            public String serialize(List<NameValuePair> data) {
                return URLEncodedUtils.format(data, (Charset)StandardCharsets.UTF_8);
            }
        };
    }

    public static ISerializationFormat<HttpEntity> toMultiPart() {
        return new ISerializationFormat<HttpEntity>(){

            @Override
            public Optional<EMimeType> getMimeType() {
                return Optional.empty();
            }

            @Override
            public String serialize(HttpEntity data) {
                throw new IllegalStateException("This should never be called directly. Call via toHttpEntity().");
            }

            @Override
            public HttpEntity toHttpEntity(HttpEntity data) {
                return data;
            }
        };
    }
}

