/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.sap;

import com.teamscale.service.admin.sap.SapSystemIdNotFoundExceptionStatusType;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;

@Provider
public class SapSystemIdNotFoundException
extends InternalServerErrorException
implements ExceptionMapper<SapSystemIdNotFoundException> {
    private static final long serialVersionUID = 1L;

    public SapSystemIdNotFoundException() {
        super("SAP system id is not configured for any project. Please contact your Teamscale administrator.");
    }

    public SapSystemIdNotFoundException(String sapSystemId) {
        super(String.format("SAP system with id %s is not configured for any project. Please contact your Teamscale administrator.", sapSystemId));
    }

    public Response toResponse(SapSystemIdNotFoundException exception) {
        return Response.status((Response.StatusType)new SapSystemIdNotFoundExceptionStatusType(Response.Status.INTERNAL_SERVER_ERROR, exception.getMessage())).build();
    }
}

