/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.architecture.ArchitectureEditorUtils;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;

@Path(value="api/projects/{project}/architectures/download")
public class ArchitectureEditorDownloadService
extends ApiBase {
    public static final String ARCHITECTURE_FILE_FORMAT = "architecture";

    @POST
    @Operation(summary="Download architecture", description="Download the architecture definition as XML.", tags={"Architecture"}, responses={@ApiResponse(responseCode="200", description="The architecture in XML format", content={@Content(mediaType="application/xml", schema=@Schema(type="string"))})})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xml"})
    public Response downloadArchitectureAsXml(@Parameter(description="The architecture data.") @FormParam(value="architectureData") String architectureData) throws ConQATException {
        ArchitectureDefinition architecture = ArchitectureEditorUtils.deserializeArchitectureDefinition((String)architectureData);
        StreamingOutput streamingOutput = output -> {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8)));
            writer.print(ArchitectureEditorUtils.architectureDefinitionToXML((ArchitectureDefinition)architecture, (PublicProjectId)this.serviceInfo.getPrimaryPublicId()));
            writer.flush();
        };
        return Response.ok((Object)streamingOutput, (String)"application/xml").header("Content-Disposition", (Object)("attachment; filename = " + architecture.getName() + ".architecture")).build();
    }
}

