/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate.saml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.saml.SamlAuthenticationOption;
import com.teamscale.core.authenticate.saml.SamlCertificateRefreshTrigger;
import com.teamscale.core.authenticate.saml.SamlUtils;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.authenticate.SsoAuthenticationServiceBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/auth/saml/sp-configuration")
public class SamlServiceProviderConfigurationService
extends SsoAuthenticationServiceBase {
    @GET
    @Operation(summary="Returns the configuration of the service provider that is stored at the named option.", description="This is meant to simplify the configuration of the identity provider.", responses={@ApiResponse(responseCode="200", description="Metadata XML", content={@Content(mediaType="application/xml")}), @ApiResponse(responseCode="404", description="No SAML option with the provided name found")})
    @RequiresNoLogin
    @Produces(value={"application/xml"})
    public Response getStoredServiceProviderConfiguration(@QueryParam(value="name") String name) {
        try {
            SamlAuthenticationOption samlAuthenticationOption = this.getSamlAuthenticationOption(name);
            ArrayList hints = new ArrayList();
            String xml = SamlUtils.createServiceProviderConfiguration((SamlAuthenticationOption)samlAuthenticationOption, (String)this.determineServiceLocationUrl(), hints);
            return Response.ok((Object)StringUtils.stringToBytes((String)xml), (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        }
        catch (StorageException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    @POST
    @Path(value="certificate/generate")
    @Operation(summary="Generate Service Provider certificate", description="Generates a new certificate for the service provider stored at the named option.", responses={@ApiResponse(responseCode="200", description="Whether the certificate could be updated", content={@Content(schema=@Schema(implementation=boolean.class), mediaType="application/json")}), @ApiResponse(responseCode="404", description="No SAML option with the provided name found")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public boolean regenerateStoredServiceProviderCertificate(@QueryParam(value="name") String name) {
        try {
            this.getSamlAuthenticationOption(name);
            return SamlCertificateRefreshTrigger.renewSamlCertificate((String)name, (IndexLayer)this.getIndexLayer(), (boolean)true);
        }
        catch (StorageException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    private SamlAuthenticationOption getSamlAuthenticationOption(String name) throws StorageException {
        IOption option = this.openGlobalIndex(ServerOptionIndex.class).getOption(SamlServiceProviderConfigurationService.buildSamlAuthenticationOptionKey(name));
        if (!(option instanceof SamlAuthenticationOption)) {
            throw new NotFoundException("No SAML configuration of this name found: " + name);
        }
        SamlAuthenticationOption samlAuthenticationOption = (SamlAuthenticationOption)option;
        return samlAuthenticationOption;
    }

    private static String buildSamlAuthenticationOptionKey(String name) {
        return "server:" + name;
    }

    @POST
    @Operation(summary="Returns the configuration of the service provider that is passed to this service.", description="This is meant to simplify the configuration of the identity provider.")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public SamlServiceProviderConfiguration getEditedServiceProviderConfiguration(@QueryParam(value="name") String name, SamlAuthenticationOption option) {
        ArrayList<String> hints = new ArrayList<String>();
        try {
            IOption existingOption = this.openGlobalIndex(ServerOptionIndex.class).getOption(SamlServiceProviderConfigurationService.buildSamlAuthenticationOptionKey(name));
            if (existingOption != null) {
                option.integrateExistingOption(existingOption);
            }
            return new SamlServiceProviderConfiguration(SamlUtils.createServiceProviderConfiguration((SamlAuthenticationOption)option, (String)this.determineServiceLocationUrl(), hints), hints);
        }
        catch (BadRequestException | StorageException e) {
            return new SamlServiceProviderConfiguration("<missing>", Collections.singletonList("Failed to create metadata: " + e.getMessage()));
        }
    }

    private String determineServiceLocationUrl() throws StorageException {
        return this.createRedirectUri("api/auth/saml/authenticate").toString();
    }

    public static class SamlServiceProviderConfiguration {
        @JsonProperty(value="hints")
        private final List<String> hints = new ArrayList<String>();
        @JsonProperty(value="metadataXml")
        private final String metadataXml;

        private SamlServiceProviderConfiguration(String metadataXml, List<String> hints) {
            this.metadataXml = metadataXml;
            this.hints.addAll(hints);
        }
    }
}

