/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dataflow.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.dataflow.taintpropagation.methodindex.EnrichedMethodTaintGraphIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodTaintGraphIndex;
import com.teamscale.index.dataflow.taintpropagation.methodindex.MethodTaintGraphIndexBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/dataflow/debug/taint-graph-indices")
public class DebugTaintGraphIndexDeserializationService
extends ApiBase {
    @GET
    @Operation(summary="Check deserialization of entries in TaintGraphIndex", description="", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String checkTaintGraphIndex(@QueryParam(value="t") @Parameter(required=true) UnresolvedCommitDescriptor commit, @QueryParam(value="checkEnrichedIndex") @Parameter(required=true) boolean checkEnrichedIndex) throws StorageException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.generateDump(printWriter, commit, checkEnrichedIndex);
        printWriter.close();
        return stringWriter.toString();
    }

    protected void generateDump(PrintWriter writer, UnresolvedCommitDescriptor commit, boolean checkEnrichedIndex) throws StorageException {
        MethodTaintGraphIndexBase subject = checkEnrichedIndex ? (MethodTaintGraphIndexBase)this.getProjectStorageSystem().openProjectIndex(EnrichedMethodTaintGraphIndex.class, this.determineHistoryOption(commit)) : (MethodTaintGraphIndexBase)this.getProjectStorageSystem().openProjectIndex(MethodTaintGraphIndex.class, this.determineHistoryOption(commit));
        List keys = subject.getAllKeys();
        writer.println("Checking Taint Graphs for " + keys.size() + " uniform paths");
        for (String key : keys) {
            try {
                subject.getMethodTaintGraphs(key);
            }
            catch (Throwable ex) {
                writer.println("Exception while deserializing graphs in file " + key);
                writer.println(ex.getMessage());
                writer.println("Raw entry value:");
                writer.println(Hex.encodeHexString((byte[])subject.getRawValue(key)));
            }
        }
    }
}

