/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.documentation.DocumentationBuilderException;
import com.teamscale.service.documentation.analysis_profile.AnalysisProfileDocumentationBuilderConfiguration;
import com.teamscale.service.documentation.analysis_profile.CodeInspectorGroupDocumentationBuilder;
import com.teamscale.service.documentation.analysis_profile.DefaultGroupDocumentationBuilder;
import com.teamscale.service.documentation.analysis_profile.GroupDocumentation;
import com.teamscale.service.documentation.analysis_profile.GroupDocumentationBuilderBase;
import com.teamscale.service.documentation.analysis_profile.ProfileDocumentation;
import com.teamscale.service.documentation.analysis_profile.QualityIndicatorDocumentation;
import eu.cqse.check.framework.core.CheckInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnalysisProfileDocumentationBuilder {
    private final ProfileDocumentation profileDocumentation;
    private final AnalysisProfileDocumentationBuilderConfiguration configuration;

    public AnalysisProfileDocumentationBuilder(AnalysisProfile profile, ConfigurationTemplate template, Map<String, CheckInfo> checkInfoMap) throws DocumentationBuilderException {
        this.configuration = new AnalysisProfileDocumentationBuilderConfiguration(template, checkInfoMap);
        this.profileDocumentation = new ProfileDocumentation(profile, this.buildQualityIndicatorsDoc(profile));
    }

    private List<QualityIndicatorDocumentation> buildQualityIndicatorsDoc(AnalysisProfile profile) throws DocumentationBuilderException {
        ArrayList<QualityIndicatorDocumentation> qualityIndicatorDocumentations = new ArrayList<QualityIndicatorDocumentation>();
        for (QualityIndicator qualityIndicator : profile.getQualityIndicators()) {
            List<GroupDocumentation> analysisGroupDocumentations = this.buildAnalysisGroupDocs(qualityIndicator);
            if (analysisGroupDocumentations.isEmpty()) continue;
            qualityIndicatorDocumentations.add(new QualityIndicatorDocumentation(qualityIndicator, analysisGroupDocumentations));
        }
        return qualityIndicatorDocumentations;
    }

    private List<GroupDocumentation> buildAnalysisGroupDocs(QualityIndicator qualityIndicator) throws DocumentationBuilderException {
        ArrayList<GroupDocumentation> analysisGroupDocumentations = new ArrayList<GroupDocumentation>();
        for (AnalysisGroup group : qualityIndicator.getGroups()) {
            GroupDocumentationBuilderBase groupDocBuilder = this.getGroupDocBuilder(group);
            GroupDocumentation analysisGroupDocumentation = groupDocBuilder.buildAnalysisGroupDocumentation(group);
            if (analysisGroupDocumentation == null) continue;
            analysisGroupDocumentations.add(analysisGroupDocumentation);
        }
        return analysisGroupDocumentations;
    }

    private GroupDocumentationBuilderBase getGroupDocBuilder(AnalysisGroup group) {
        EAnalysisTool tool = AnalysisProfileUtils.getAnalysisTool((AnalysisGroup)group, (ConfigurationTemplate)this.configuration.getTemplate());
        switch (tool) {
            case CODE_INSPECTOR: {
                return new CodeInspectorGroupDocumentationBuilder(this.configuration);
            }
        }
        return new DefaultGroupDocumentationBuilder(this.configuration);
    }

    public ProfileDocumentation getAnalysisProfileDoc() {
        return this.profileDocumentation;
    }
}

