/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoMetricSchemaChange;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/metric-update")
public class ExternalMetricsInProjectUpdateService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    private static final String COMMIT_MESSAGE = "Update metrics schema in project.";
    private static final String UPDATE_METRICS_IN_PROJECT_PARTITION = "update-metrics-in-project-partition";
    private List<MetricSchemaChangeEntry> addedExternalMetrics;

    @POST
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_ANALYSIS_PROFILES)
    @Operation(summary="Update project metric schema", description="Updates the project metric schema with the entries in the analysis profile.", tags={"Project", "External Metrics"}, responses={@ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time.")})
    public void updateExternalMetricSchema(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="The name of the analysis profile used to extract the enabled external metrics.", required=true) @QueryParam(value="analysis-profile-name") String analysisProfileName) throws StorageException {
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfile newAnalysisProfile = AnalysisProfileUtils.updateAnalysisProfile((AnalysisProfileIndex)analysisProfileIndex, (ProjectStorageSystem)this.getProjectStorageSystem(), (String)analysisProfileName);
        List externalMetricsDescriptions = this.openGlobalIndex(ExternalCodeMetricsDescriptionIndex.class).getAllMetrics();
        List<MetricSchemaChangeEntry> enabledExternalMetrics = ExternalMetricsInProjectUpdateService.findEnabledExternalMetricsInProfile(newAnalysisProfile, externalMetricsDescriptions);
        MetricDirectorySchema metricSchema = this.openProjectIndex(MetricSchemaIndex.class, "metric-schema", HistoryAccessOption.readHeadUnbranched()).getSchema(false);
        this.addedExternalMetrics = ExternalMetricsInProjectUpdateService.getAddedExternalMetrics(enabledExternalMetrics, metricSchema);
        if (this.addedExternalMetrics.isEmpty()) {
            return;
        }
        SessionBasedExternalAnalysisServiceQueryOptions parameters = new SessionBasedExternalAnalysisServiceQueryOptions();
        parameters.setCommit(commit);
        parameters.setUploadMessage(COMMIT_MESSAGE);
        parameters.setPartition(UPDATE_METRICS_IN_PROJECT_PARTITION);
        this.process(EHttpMethod.POST, null, parameters, "auto-create");
    }

    private static List<MetricSchemaChangeEntry> getAddedExternalMetrics(List<MetricSchemaChangeEntry> enabledExternalMetrics, MetricDirectorySchema metricSchema) {
        ArrayList<MetricSchemaChangeEntry> addedExternalMetrics = new ArrayList<MetricSchemaChangeEntry>();
        for (MetricSchemaChangeEntry metricSchemaChangeEntry : enabledExternalMetrics) {
            String metricName = metricSchemaChangeEntry.getMetricDirectoryEntry().getName();
            MetricDirectorySchemaEntry schemaEntry = metricSchema.getEntry(metricName);
            if (schemaEntry != null) continue;
            addedExternalMetrics.add(metricSchemaChangeEntry);
        }
        return addedExternalMetrics;
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, List<IExternalUploadRequestPart> externalAnalysisResults, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        ExternalAnalysisImportInfoMetricSchemaChange info = new ExternalAnalysisImportInfoMetricSchemaChange(this.addedExternalMetrics);
        ExternalAnalysisImportInfos infos = new ExternalAnalysisImportInfos(Collections.singletonList(info));
        sessionIndex.insertImportInfos(session, Collections.singletonList(infos));
    }

    private static List<MetricSchemaChangeEntry> findEnabledExternalMetricsInProfile(AnalysisProfile newAnalysisProfile, List<MetricSchemaChangeEntry> existingDescriptions) {
        Map entriesMappedByGroupName = existingDescriptions.stream().collect(Collectors.toMap(entry -> entry.getMetricDirectoryEntry().getName(), Function.identity()));
        return newAnalysisProfile.getQualityIndicators().stream().flatMap(indicator -> indicator.getGroups().stream()).flatMap(group -> ExternalMetricsInProjectUpdateService.enabledMetricNames(entriesMappedByGroupName, group)).map(entriesMappedByGroupName::get).collect(Collectors.toList());
    }

    private static Stream<String> enabledMetricNames(Map<String, MetricSchemaChangeEntry> entriesMappedByGroupName, AnalysisGroup group) {
        return group.getOptionNames().stream().filter(name -> "true".equalsIgnoreCase(group.getOptionValue(name)) && entriesMappedByGroupName.containsKey(name));
    }
}

