/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.clangtidy.debug;

import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.clangtidy.ClangTidyRunner;
import com.teamscale.index.findings.clangtidy.ClangTidySynchronizer;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.SetupVerificationServiceUtils;
import com.teamscale.service.findings.clangtidy.ToolSetupDebugServiceUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.reflect.TypeConversionException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/clang-tidy/debug/execution-setup")
public class DebugClangTidySetupService
extends ApiBase {
    @VisibleForTesting
    public static final String TARGET_DIRECTORY_PARAM_NAME = "targetDir";
    private static final String TARGET_DIRECTORY_PARAM_DESCRIPTION = "The directory in which the service will store the execution environment. All current files in the directory will be deleted. The service requires admin permission since this can be abused.";

    @GET
    @Path(value="disk/{uniformPath: .*}")
    @Operation(summary="Stores a clang-tidy execution setup for the given uniform path in the given directory. The file ClangTidyCommand.txt contains the exact command we execute to run clang-tidy.", description="Stores a clang-tidy execution setup for the given uniform path in the given directory.", tags={"Source Code"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String storeExecutionSetup(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="targetDir") @Parameter(description="The directory in which the service will store the execution environment. All current files in the directory will be deleted. The service requires admin permission since this can be abused.") String directoryPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException, IOException, TypeConversionException {
        File targetDir = SetupVerificationServiceUtils.setupCleanTargetDir(directoryPath);
        this.createToolSetupInDirectory(uniformPath, commit, targetDir);
        return "Prepared the setup in " + directoryPath + ". Execute the command listed in check/ClangTidyCommand.txt to run the setup.";
    }

    @GET
    @Path(value="zip/{uniformPath: .*}")
    @Produces(value={"application/zip"})
    @Operation(summary="Returns a clang-tidy execution setup for the given uniform path as a ZIP file. The file ClangTidyCommand.txt contains the exact command we execute to run clang-tidy.", description="Returns a clang-tidy execution setup for the given uniform path as a ZIP file.", tags={"Source Code"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response getExecutionSetupAsZip(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException, IOException, TypeConversionException {
        File targetDir = Files.createTempDirectory("clang-tidy-setup", new FileAttribute[0]).toFile();
        this.createToolSetupInDirectory(uniformPath, commit, targetDir);
        StreamingOutput streamingOutput = output -> {
            try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(output));){
                DebugClangTidySetupService.addDirectoryToZip(targetDir, zipOutputStream, "");
            }
            finally {
                FileUtils.deleteDirectory((File)targetDir);
            }
        };
        return ResponseUtils.getFileDownloadResponse((Object)streamingOutput, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)("clang-tidy-setup_" + uniformPath.getLastSegment() + ".zip"));
    }

    private void createToolSetupInDirectory(UniformPath uniformPath, UnresolvedCommitDescriptor commit, File targetDir) throws StorageException, TypeConversionException, IOException {
        TokenElementInfo subjectElement = this.openProjectIndex(TokenElementIndex.class, "content", this.determineHistoryOption(commit)).getTokenElement(uniformPath);
        if (subjectElement == null) {
            throw new IllegalArgumentException("Could not find file " + String.valueOf(uniformPath) + " in commit " + String.valueOf(commit));
        }
        CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement((BasicTokenElementInfo)subjectElement);
        TriggerDescription.Parameters triggerParameters = this.determineTriggerProperties().getTriggerParameters();
        CodeScopeAware<PairList<String, String>> checkOptions = ToolSetupDebugServiceUtils.loadCodeScopeAwarePairListParameter((TriggerDescription.Parameters<String>)triggerParameters, "check-options", codeScopeName);
        CodeScopeAware<List<String>> selectedChecks = ToolSetupDebugServiceUtils.loadCodeScopeAwareListParameter((TriggerDescription.Parameters<String>)triggerParameters, "checks", codeScopeName);
        CodeScopeAware<String> enabledChecksForCRegex = ToolSetupDebugServiceUtils.loadStringParameter((TriggerDescription.Parameters<String>)triggerParameters, "enabled-checks-for-c-regex", codeScopeName);
        CodeScopeAware checkSelectorByLanguage = ClangTidySynchronizer.buildCheckSelectorsForCodeScopes(selectedChecks, enabledChecksForCRegex, Collections.singleton(codeScopeName));
        CodeScopeAware globalCompilerArguments = CppIncludeHandler.determineGlobalCompilerIncludeDirArguments((MetaIndex)this.openProjectIndex(MetaIndex.class, null), Collections.singleton(codeScopeName));
        CppToolAnalysisTokenElementDetails tokenElementDetails = CppToolAnalysisTokenElementDetails.extractFromTokenElement((TokenElementInfo)subjectElement);
        CppIncludeHandler includeHandler = this.createCppIncludeHandler(this.determineHistoryOption(commit));
        ClangTidyRunner runner = new ClangTidyRunner(checkOptions.map(PairList::toMap));
        runner.prepareAndRunClangTidy(Collections.singletonList(subjectElement), (File)new CanonicalFile(targetDir), checkSelectorByLanguage, globalCompilerArguments, true, includeHandler, tokenElementDetails);
    }

    private CppIncludeHandler createCppIncludeHandler(HistoryAccessOption historyAccessOption) throws StorageException {
        BasicTokenElementIndex basicContentIndex = this.openProjectIndex(BasicTokenElementIndex.class, historyAccessOption);
        CompileCommandIndex compileCommandIndex = this.openProjectIndex(CompileCommandIndex.class, historyAccessOption);
        PathLookupIndex pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccessOption);
        MetaIndex metaIndex = this.openProjectIndex(MetaIndex.class, null);
        SystemIncludeFileCacheIndex systemIncludeFileCacheIndex = this.openGlobalIndex(SystemIncludeFileCacheIndex.class);
        SystemIncludeFileLookup systemIncludeFileLookup = SystemIncludeFileLookup.create((MetaIndex)metaIndex, (SystemIncludeFileCacheIndex)systemIncludeFileCacheIndex);
        FileIncludeLookup fileIncludeLookup = new FileIncludeLookup((IMatchingPathsLookup)pathLookupIndex, systemIncludeFileLookup);
        return new CppIncludeHandler(basicContentIndex, compileCommandIndex, fileIncludeLookup, this.serviceInfo.getLockProvider());
    }

    public static void addDirectoryToZip(File directory, ZipArchiveOutputStream zipOutputStream, String path) throws IOException {
        zipOutputStream.setUseZip64(Zip64Mode.AsNeeded);
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String entryPath;
            String string = entryPath = path.isEmpty() ? file.getName() : path + "/" + file.getName();
            if (file.isDirectory()) {
                DebugClangTidySetupService.addDirectoryToZip(file, zipOutputStream, entryPath);
                continue;
            }
            zipOutputStream.putArchiveEntry(new ZipArchiveEntry(entryPath));
            try (FileInputStream inputStream = new FileInputStream(file);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
            }
            zipOutputStream.closeArchiveEntry();
        }
    }

    private TriggerDescription determineTriggerProperties() throws StorageException {
        TriggerDescription clangTidyTriggerDescriptor = this.openProjectIndex(TriggerIndex.class, null).getTrigger(ClangTidySynchronizer.class.getSimpleName());
        if (clangTidyTriggerDescriptor == null) {
            throw new IllegalArgumentException("Did not find a ClangTidySynchronizer to determine enabled checks and options.");
        }
        CCSMAssert.isTrue((boolean)clangTidyTriggerDescriptor.getTriggerParameters().getParameterKeys().containsAll(Arrays.asList("checks", "check-options", "enabled-checks-for-c-regex")), (String)"Options of ClangTidySynchronizer have been renamed.");
        return clangTidyTriggerDescriptor;
    }
}

