/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.badge;

import com.teamscale.service.badge.StaticBadgeUtils;
import com.teamscale.service.badge.velocity.BadgeCreator;
import com.teamscale.service.badge.velocity.metric.MetricBadgeData;
import com.teamscale.service.framework.badge.SvgUtils;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;

public class MergeRequestMetricBadgeCreator {
    private static final String SEGMENTED_METRIC_BADGE_TEMPLATE_PATH = "com/teamscale/service/metrics/badge/segmented-metric-badge-with-icon-template.svg";
    private final String metricName;
    private final ETrafficLightColor assessmentColor;
    private final String metricResult;
    private final String incompleteBuildText;

    public MergeRequestMetricBadgeCreator(String metricName, String metricResult, ETrafficLightColor assessmentColor, String incompleteBuildText) {
        this.metricName = metricName;
        this.assessmentColor = assessmentColor;
        this.metricResult = metricResult;
        this.incompleteBuildText = incompleteBuildText;
    }

    public byte[] createBadge() {
        MetricBadgeData badgeData = new MetricBadgeData();
        String buildJobWarningText = StaticBadgeUtils.appendBuildJobsSegment(badgeData, this.incompleteBuildText);
        badgeData.appendTitle(this.metricName, "");
        if (StringUtils.isEmpty((String)this.metricResult)) {
            badgeData.appendSegment("unknown", "GRAY");
            return StringUtils.stringToBytes((String)BadgeCreator.createBadge(badgeData));
        }
        String color = this.assessmentColor.name();
        if (this.assessmentColor == ETrafficLightColor.YELLOW) {
            color = "#FBBC05";
            badgeData.appendSegmentWithYellowMetricIcon(this.metricResult, "", color, this.getMetricAssessmentIconStart(buildJobWarningText));
        } else if (this.assessmentColor == ETrafficLightColor.ORANGE) {
            badgeData.appendSegmentWithYellowMetricIcon(this.metricResult, "", color, this.getMetricAssessmentIconStart(buildJobWarningText));
        } else if (this.assessmentColor == ETrafficLightColor.RED) {
            badgeData.appendSegmentWithRedMetricIcon(this.metricResult, "", color, this.getMetricAssessmentIconStart(buildJobWarningText));
        } else if (this.assessmentColor == ETrafficLightColor.GREEN) {
            badgeData.appendSegmentWithGreenMetricIcon(this.metricResult, "", color, this.getMetricAssessmentIconStart(buildJobWarningText));
        } else {
            badgeData.appendSegment(this.metricResult, color);
        }
        return StringUtils.stringToBytes((String)BadgeCreator.createBadge(SEGMENTED_METRIC_BADGE_TEMPLATE_PATH, badgeData));
    }

    private double getMetricAssessmentIconStart(String buildJobWarningText) {
        double result = SvgUtils.computeTextWidth((String)this.metricName) + 10;
        if (!buildJobWarningText.isEmpty()) {
            result += (double)(SvgUtils.computeTextWidth((String)buildJobWarningText) + 10);
        }
        return result;
    }
}

