/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.EAnalysisToolCategory;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/feature-list.md")
public class FeatureListService
extends ApiBase {
    @GET
    @Operation(summary="Get features", description="Generates a list of features from the registered configurations.", tags={"Miscellaneous"})
    @RequiresNoPermission
    @Produces(value={"text/plain"})
    public String getFeatures(@Parameter(description="Allows to include experimental features.") @QueryParam(value="experimental") boolean includeExperimental, @Parameter(description="The languages for which the features should be listed.") @QueryParam(value="language") Set<ELanguage> includedLanguages) throws ProjectConfigurationException {
        if (includedLanguages.isEmpty()) {
            includedLanguages.addAll(Arrays.asList(ELanguage.getUserVisibleLanguages()));
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        FeatureListService.appendLanguagesSection(writer, includedLanguages);
        FeatureListService.appendInfrastructureSection(writer, includeExperimental);
        this.appendAnalysisSection(writer, includeExperimental, includedLanguages);
        FeatureListService.appendToolsSection(writer, includedLanguages);
        writer.close();
        return stringWriter.toString();
    }

    private static void appendLanguagesSection(PrintWriter writer, Set<ELanguage> languages) {
        FeatureListService.printSectionCaption(writer, "Supported Languages");
        for (ELanguage language : AnalysisProfileUtils.getSupportedLanguages()) {
            if (!languages.contains(language)) continue;
            FeatureListService.printItem(writer, language.getReadableName());
        }
        writer.println();
    }

    private static void appendInfrastructureSection(PrintWriter writer, boolean includeExperimental) {
        FeatureListService.printSectionCaption(writer, "Supported Development Infrastructure");
        List connectors = ConfigRegistry.getInstance().createAllDescriptors();
        ListMap connectorsByType = new ListMap();
        for (ConnectorDescriptorBase connector : connectors) {
            if (FeatureListService.isExcludedExperimental(includeExperimental, connector.getClass())) continue;
            connectorsByType.add((Object)connector.getConnectorType(), (Object)connector);
        }
        writer.println();
        for (EConnectorType type : EConnectorType.getAllowedConnectorTypes()) {
            FeatureListService.appendConnectorSubsection(writer, (List)connectorsByType.getCollection((Object)type), type.displayName);
        }
    }

    private static void appendConnectorSubsection(PrintWriter writer, List<? extends ConnectorDescriptorBase> connectors, String caption) {
        if (connectors == null || connectors.isEmpty()) {
            return;
        }
        FeatureListService.printSubsectionCaption(writer, caption);
        for (ConnectorDescriptorBase connectorDescriptorBase : connectors) {
            Object name = connectorDescriptorBase.getName();
            if (connectorDescriptorBase.getUrl() != null) {
                name = "[" + (String)name + "](" + connectorDescriptorBase.getUrl() + ")";
            }
            FeatureListService.printItem(writer, (String)name, connectorDescriptorBase.getDescription());
        }
        writer.println();
    }

    private void appendAnalysisSection(PrintWriter writer, boolean includeExperimental, Set<ELanguage> languages) throws ProjectConfigurationException {
        ConfigurationTemplate template = ConfigRegistry.getInstance().createConfigurationTemplate(languages, EnumSet.noneOf(EAnalysisTool.class), this.getGlobalStorageSystem());
        FeatureListService.printSectionCaption(writer, "Built-in Analyses");
        for (AnalysisGroupDescriptor analysisGroup : template.getAnalysisGroups()) {
            if (FeatureListService.isExcludedExperimental(includeExperimental, analysisGroup)) continue;
            FeatureListService.appendAnalysisGroupSubsection(writer, includeExperimental, analysisGroup);
        }
    }

    private static void appendAnalysisGroupSubsection(PrintWriter writer, boolean includeExperimental, AnalysisGroupDescriptor analysisGroup) {
        FeatureListService.printSubsectionCaption(writer, analysisGroup.getName());
        for (ConfigurationItemBase configurationItem : analysisGroup.getConfigurationItems()) {
            if (FeatureListService.isExcludedExperimental(includeExperimental, configurationItem)) continue;
            FeatureListService.printItem(writer, configurationItem.getName(), configurationItem.getDescription());
        }
        writer.println();
    }

    private static void appendToolsSection(PrintWriter writer, Set<ELanguage> languages) {
        ListMap toolsByCategory = new ListMap();
        for (EAnalysisTool eAnalysisTool : EAnalysisTool.values()) {
            if (!eAnalysisTool.isAvailableAndSupportsOneOf(languages)) continue;
            toolsByCategory.add((Object)eAnalysisTool.getCategory(), (Object)eAnalysisTool);
        }
        FeatureListService.printSectionCaption(writer, "Supported Analysis Tools");
        for (EAnalysisTool eAnalysisTool : EAnalysisToolCategory.values()) {
            if (eAnalysisTool == EAnalysisToolCategory.INTERNAL) continue;
            FeatureListService.appendToolsCategorySubsection(writer, (EAnalysisToolCategory)eAnalysisTool, languages, (List)toolsByCategory.getCollection((Object)eAnalysisTool));
        }
    }

    private static void appendToolsCategorySubsection(PrintWriter writer, EAnalysisToolCategory category, Set<ELanguage> languages, List<EAnalysisTool> tools) {
        if (tools == null || tools.isEmpty()) {
            return;
        }
        FeatureListService.printSubsectionCaption(writer, category.getName());
        for (EAnalysisTool tool : tools) {
            FeatureListService.printItem(writer, "[" + tool.getReadableName() + "](" + tool.getUrl() + ")", FeatureListService.getLanguages(languages, tool));
        }
        writer.println();
    }

    private static String getLanguages(Set<ELanguage> languages, EAnalysisTool tool) {
        ArrayList<String> languageNames = new ArrayList<String>();
        for (ELanguage language : AnalysisProfileUtils.getSupportedLanguages()) {
            if (!languages.contains(language) || !tool.isAvailableAndSupportsOneOf(EnumSet.of(language))) continue;
            languageNames.add(language.getReadableName());
        }
        return StringUtils.concat(languageNames, (String)", ");
    }

    private static void printSectionCaption(PrintWriter writer, String caption) {
        writer.println("# " + caption);
        writer.println();
    }

    private static void printSubsectionCaption(PrintWriter writer, String caption) {
        writer.println("## " + caption);
    }

    private static void printItem(PrintWriter writer, String name) {
        FeatureListService.printItem(writer, name, null);
    }

    private static void printItem(PrintWriter writer, String name, String details) {
        if (details == null) {
            writer.println("- " + name);
        } else {
            writer.println("- " + name + ": " + details);
        }
    }

    private static boolean isExcludedExperimental(boolean includeExperimental, Class<?> classToCheck) {
        return !includeExperimental && classToCheck.getName().contains(".incubator.");
    }

    private static boolean isExcludedExperimental(boolean includeExperimental, AnalysisGroupDescriptor analysisGroup) throws ProjectConfigurationException {
        if (includeExperimental) {
            return false;
        }
        for (AnalysisConfigurationBase configuration : analysisGroup.getReferencedConfigurations(EnumSet.noneOf(EAnalysisTool.class))) {
            if (!FeatureListService.isExcludedExperimental(includeExperimental, configuration.getClass())) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludedExperimental(boolean includeExperimental, ConfigurationItemBase configurationItem) {
        return !includeExperimental && configurationItem.getVisibility() == ConfigExposed.EConfigVisibility.EXPERIMENTAL;
    }
}

