/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.quality_report.QualityArtifactParameters;
import com.teamscale.index.quality_report.QualityReport;
import com.teamscale.index.quality_report.QualityReportsIndex;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.SlideRenderDataIndex;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import com.teamscale.service.reports.QualityArtifactServiceBase;
import com.teamscale.service.reports.ReportSlideWithRenderData;
import com.teamscale.service.reports.slides.ISlideRenderer;
import com.teamscale.service.reports.slides.SlideRendererFactory;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/quality-reports")
public class QualityReportsService
extends QualityArtifactServiceBase<QualityReport> {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresNoPermission(description="No permissions needed, as the service will only return reports visible to current user.")
    @Operation(summary="Get quality reports", description="Returns all stored reports details, without slide contents.", tags={"Reporting"})
    public List<UserResolvedQualityReport> listQualityReports(@Parameter(description="The project id") @QueryParam(value="projectId") PublicProjectId projectId) throws StorageException {
        List<Object> visibleReports = PermissionFilterUtils.getVisibleQualityReports(this.getPermissions(), this.openQualityArtifactIndex());
        if (projectId != null) {
            visibleReports = visibleReports.stream().filter(qualityReport -> this.shouldReportBeShownForProject((QualityReport)qualityReport, projectId)).toList();
        }
        if (visibleReports.isEmpty()) {
            return Collections.emptyList();
        }
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        return CollectionUtils.map(visibleReports, report -> new UserResolvedQualityReport((QualityReport)report, userAliasLookup.resolveUser(report.getMetaInfo().getAuthor()).orElse(null)));
    }

    @GET
    @Path(value="{id}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.VIEW}, entityPathParameter="id")
    @Operation(summary="Get report", description="Returns the report.", tags={"Reporting"})
    public QualityReport getReport(@Parameter(description="The report id") @PathParam(value="id") String reportID) throws StorageException {
        return (QualityReport)this.getElementWithExistsCheck(reportID);
    }

    @DELETE
    @Path(value="{id}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.DELETE}, entityPathParameter="id")
    @Operation(summary="Delete report", description="Deletes the report with the given id.", tags={"Reporting"})
    public void deleteQualityReport(@Parameter(description="The report id") @PathParam(value="id") String reportId) throws StorageException {
        this.deleteElementAndPermissions((QualityReport)this.getElementWithExistsCheck(reportId));
        this.openSlideRenderDataIndex().removeRenderDataForAllSlides(reportId);
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_QUALITY_REPORTS})
    @Operation(summary="Create quality report", description="Creates a new quality report either from scratch or by copying an existing report.", tags={"Reporting"})
    public String createQualityReport(@RequestBody(required=true) QualityArtifactParameters reportParameters, @Parameter(description="The id of the report to be copied") @QueryParam(value="from-template") String templateReportId) throws StorageException {
        QualityReport newReport;
        if (templateReportId != null) {
            this.getPermissions().checkBasicPermission(EBasicPermissionScope.REPORTS, templateReportId, EBasicPermission.VIEW);
            newReport = (QualityReport)this.copyQualityArtifact(templateReportId, reportParameters);
        } else {
            newReport = reportParameters.createQualityReport(null, DateTimeUtils.millisNow(), this.getUser().getUsername());
        }
        this.createElementAndPermissions(newReport);
        this.prerenderSlides(newReport, CollectionUtils.map((Collection)newReport.getSlides(), ReportSlideBase::getId), null);
        return newReport.getMetaInfo().getId();
    }

    @PUT
    @Path(value="{id}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.EDIT}, entityPathParameter="id")
    @Operation(summary="Updates quality report", description="Updates a quality report's metadata such as title and global settings like default project and threshold profile.", tags={"Reporting"})
    public void updateQualityReport(@Parameter(description="The ID of the report that gets an update.") @PathParam(value="id") String reportId, @RequestBody(required=true) QualityArtifactParameters reportParameters) throws StorageException {
        QualityReport oldReport = (QualityReport)this.getElementWithExistsCheck(reportId);
        boolean baseSettingsChanged = !oldReport.getQualityArtifactProfile().equals((Object)reportParameters.qualityArtifactProfile());
        QualityReport newReport = this.createReportFromTemplate(oldReport.getMetaInfo().getId(), oldReport, reportParameters, oldReport.getMetaInfo().getCreationTimestamp(), oldReport.getMetaInfo().getAuthor(), baseSettingsChanged);
        this.updateElement(oldReport, newReport);
        if (baseSettingsChanged) {
            oldReport = null;
        }
        this.prerenderSlides(newReport, CollectionUtils.map((Collection)newReport.getSlides(), ReportSlideBase::getId), oldReport);
    }

    @PUT
    @Path(value="{id}/update-slides")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.EDIT}, entityPathParameter="id")
    @Operation(summary="Update report slide", description="Updates an existing slide in a quality report.", tags={"Reporting"})
    public void updateQualityReportSlides(@Parameter(description="The ID of the report that is updated.") @PathParam(value="id") String reportId, @RequestBody(required=true, description="The slides to update, identified by their slide id.") List<ReportSlideBase> slides) throws StorageException, MetricThresholdConfigurationException {
        QualityReport oldReport = (QualityReport)this.getElementWithExistsCheck(reportId);
        QualityReport report = this.updateSlideForReport(oldReport, slides);
        this.updateElement(null, report);
        this.prerenderSlides(report, CollectionUtils.map(slides, ReportSlideBase::getId), oldReport);
    }

    @GET
    @Path(value="{reportId}/slides/{slideId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.VIEW}, entityPathParameter="reportId")
    @Operation(summary="Get report slide", description="Returns the data necessary to render the slide in the frontend.", tags={"Reporting"})
    public ReportSlideWithRenderData getReportSlide(@Parameter(description="The ID of the report.") @PathParam(value="reportId") String reportId, @Parameter(description="The ID of the slide.") @PathParam(value="slideId") String slideId) throws StorageException, MetricThresholdConfigurationException {
        QualityReport report = (QualityReport)this.getElementWithExistsCheck(reportId);
        ReportSlideBase slide = report.findSlideById(slideId);
        if (slide == null) {
            throw new BadRequestException("Report slide with ID '" + slideId + "' could not be found");
        }
        SlideRenderDataBase renderData = this.getOrComputeRenderData(reportId, slideId, slide, report);
        return new ReportSlideWithRenderData(slide, renderData);
    }

    private SlideRenderDataBase getOrComputeRenderData(String reportId, String slideId, ReportSlideBase slide, QualityReport report) throws StorageException, MetricThresholdConfigurationException {
        SlideRenderDataBase storedRenderData = this.openSlideRenderDataIndex().getSlideRenderData(reportId, slideId);
        if (storedRenderData != null) {
            return storedRenderData;
        }
        SlideRenderDataBase renderData = this.renderSlide(report, slide, null);
        this.openSlideRenderDataIndex().setSlideRenderData(reportId, PairList.from((Object)slideId, (Object)renderData));
        return renderData;
    }

    @POST
    @Path(value="{reportId}/add-slides")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.EDIT}, entityPathParameter="reportId")
    @Operation(summary="Add report slide", description="Adds slide(s) to an existing quality report.", tags={"Reporting"})
    public void addQualityReportSlides(@Parameter(description="The ID of the report that is added.") @PathParam(value="reportId") String reportId, @RequestBody(required=true, description="The slides to add") Map<Integer, ReportSlideBase> slidesWithPositions) throws StorageException, MetricThresholdConfigurationException {
        QualityReport report = this.addSlidesForReport(reportId, slidesWithPositions);
        this.updateElement(null, report);
        this.prerenderSlides(report, CollectionUtils.map(slidesWithPositions.values(), ReportSlideBase::getId), null);
    }

    @POST
    @Path(value="{reportId}/remove-slides")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.EDIT}, entityPathParameter="reportId")
    @Operation(summary="Delete report slides", description="Deletes the given slides from an existing report.", tags={"Reporting"})
    public void removeQualityReportSlides(@Parameter(description="The id of the report that is edited.") @PathParam(value="reportId") String reportId, @RequestBody(required=true, description="The ids of the slides to delete.") List<String> slideIdsToDelete) throws StorageException {
        QualityReport report = (QualityReport)this.getElementWithExistsCheck(reportId);
        slideIdsToDelete.forEach(arg_0 -> ((QualityReport)report).removeSlide(arg_0));
        this.updateElement(null, report);
        this.openSlideRenderDataIndex().removeSlideRenderData(reportId, slideIdsToDelete);
    }

    @PUT
    @Path(value="{reportId}/show-slide-numbers")
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, permissions={EBasicPermission.EDIT}, entityPathParameter="reportId")
    @Operation(summary="Set whether slide numbers should be shown", description="Toggles showing the numbers on the corresponding slides.", tags={"Reporting"})
    public void showSlideNumbers(@Parameter(description="The id of the report that is edited.") @PathParam(value="reportId") String reportId, @Parameter(description="Whether the slide numbers should be shown") @QueryParam(value="showSlideNumbers") boolean showSlidesNumbers) throws StorageException {
        QualityReport report = (QualityReport)this.getElementWithExistsCheck(reportId);
        report.setShowSlideNumbers(showSlidesNumbers);
        this.updateElement(null, report);
    }

    private boolean shouldReportBeShownForProject(QualityReport qualityReport, PublicProjectId projectId) {
        if (qualityReport.getQualityArtifactProfile().getDefaultProjectSetting().getProjectId().equals((Object)projectId)) {
            return true;
        }
        for (ReportSlideBase slide : qualityReport.getSlides()) {
            if (!slide.getSlideParameters().getReferencedProjects().contains(projectId)) continue;
            return true;
        }
        return false;
    }

    private @NonNull QualityReport updateSlideForReport(QualityReport oldReport, List<ReportSlideBase> slides) {
        QualityReport report = (QualityReport)SerializationUtils.cloneBySerialization((Serializable)oldReport);
        for (ReportSlideBase slideData : slides) {
            int slideIndex = report.getSlideIndex(slideData.getId());
            if (slideIndex == -1) {
                throw new BadRequestException("Report slide with ID '" + slideData.getId() + "' could not be found");
            }
            report.setReportSlide(slideData.getId(), slideData);
        }
        return report;
    }

    private @NonNull QualityReport addSlidesForReport(String reportId, Map<Integer, ReportSlideBase> slidesWithPositions) throws StorageException {
        QualityReport report = (QualityReport)this.getElementWithExistsCheck(reportId);
        for (Map.Entry<Integer, ReportSlideBase> slideAndIndex : slidesWithPositions.entrySet()) {
            report.insertSlide(slideAndIndex.getKey().intValue(), slideAndIndex.getValue());
        }
        return report;
    }

    private void prerenderSlides(QualityReport newReport, List<String> updatedSlideIds, @Nullable QualityReport oldReport) throws StorageException {
        String reportId = newReport.getMetaInfo().getId();
        PairList updatedSlides = new PairList();
        for (String updatedSlideId : updatedSlideIds) {
            try {
                ReportSlideWithRenderData existingSlideWithRenderData = this.getReportSlideWithRenderData(oldReport, updatedSlideId);
                SlideRenderDataBase renderData = this.renderSlide(newReport, newReport.findSlideById(updatedSlideId), existingSlideWithRenderData);
                updatedSlides.add((Object)updatedSlideId, (Object)renderData);
            }
            catch (MetricThresholdConfigurationException | StorageException e) {
                LOGGER.error("Failed to render slide", e);
                updatedSlides.add((Object)updatedSlideId, null);
            }
        }
        this.openSlideRenderDataIndex().setSlideRenderData(reportId, updatedSlides);
    }

    private @Nullable ReportSlideWithRenderData getReportSlideWithRenderData(@Nullable QualityReport oldReport, String slideId) throws StorageException {
        if (oldReport == null) {
            return null;
        }
        ReportSlideBase oldSlide = oldReport.findSlideById(slideId);
        if (oldSlide == null) {
            return null;
        }
        SlideRenderDataBase slideRenderData = this.openSlideRenderDataIndex().getSlideRenderData(oldReport.getMetaInfo().getId(), slideId);
        return new ReportSlideWithRenderData(oldSlide, slideRenderData);
    }

    private SlideRenderDataBase renderSlide(QualityReport report, ReportSlideBase slide, @Nullable ReportSlideWithRenderData existingSlide) throws StorageException, MetricThresholdConfigurationException {
        ISlideRenderer renderer = SlideRendererFactory.createRender(this.serviceInfo, slide.getSlideType(), slide.getSlideParameters(), report);
        return renderer.createSlideResult(existingSlide);
    }

    protected QualityReportsIndex openQualityArtifactIndex() throws StorageException {
        return this.openGlobalIndex(QualityReportsIndex.class);
    }

    private SlideRenderDataIndex openSlideRenderDataIndex() throws StorageException {
        return this.openGlobalIndex(SlideRenderDataIndex.class);
    }

    @Override
    protected void checkMayCreateQualityArtifact(QualityArtifactParameters tempQualityArtifact) throws StorageException {
        PublicProjectId defaultProjectIdOfNewReport = tempQualityArtifact.qualityArtifactProfile().getDefaultProjectSetting().getProjectId();
        if (!this.getPermissions().userHasProjectPermission((IProjectId)defaultProjectIdOfNewReport, EProjectPermission.VIEW)) {
            throw new ForbiddenException("User may not view default project of new report: " + String.valueOf(defaultProjectIdOfNewReport));
        }
    }

    @Override
    protected EBasicPermissionScope getPermissionScope() {
        return EBasicPermissionScope.REPORTS;
    }

    @Override
    protected QualityReport createQualityArtifactCopy(QualityArtifactParameters artifactParameters, QualityReport existingReport) {
        return this.createReportFromTemplate(null, existingReport, artifactParameters, DateTimeUtils.millisNow(), this.getUser().getUsername(), true);
    }

    private QualityReport createReportFromTemplate(@Nullable String id, QualityReport templateReport, QualityArtifactParameters artifactParameters, long creationTimestamp, String author, boolean baseSettingsChanged) {
        ProjectBranchPath oldProjectBranchPath = templateReport.getQualityArtifactProfile().getDefaultProjectSetting();
        ProjectBranchPath newProjectBranchPath = artifactParameters.qualityArtifactProfile().getDefaultProjectSetting();
        QualityReport newReport = artifactParameters.createQualityReport(id, creationTimestamp, author);
        newReport.setShowSlideNumbers(templateReport.getShowSlideNumbers());
        templateReport.getSlides().forEach(slide -> {
            slide.reset(artifactParameters, baseSettingsChanged);
            slide.updateDefaultProjectBranchPath(oldProjectBranchPath, newProjectBranchPath);
            newReport.addSlide(slide);
        });
        return newReport;
    }

    private static class UserResolvedQualityReport {
        @JsonUnwrapped
        private final QualityReport report;
        @JsonProperty(value="user")
        private final @Nullable User user;
        @JsonProperty(value="slideCount")
        private final int slideCount;
        @JsonProperty(value="draftSlideCount")
        private final int draftSlideCount;

        private UserResolvedQualityReport(QualityReport report, @Nullable User user) {
            this.report = report;
            this.user = user;
            this.slideCount = report.getSlides().size();
            this.draftSlideCount = Math.toIntExact(report.getSlides().stream().filter(slide -> slide.getSlideParameters().slideIsDraft()).count());
            report.getSlides().clear();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UserResolvedQualityReport that = (UserResolvedQualityReport)o;
            return this.slideCount == that.slideCount && this.draftSlideCount == that.draftSlideCount && Objects.equals(this.user, that.user);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.user, this.slideCount, this.draftSlideCount);
        }
    }
}

