/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search.result;

import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import com.teamscale.service.search.SearchQuery;
import com.teamscale.service.search.result.FileSearchHit;
import com.teamscale.service.search.result.SearchResult;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public abstract class SearchHitBase
implements Comparable<SearchHitBase> {
    private static final int MAX_TOKEN_DISTANCE = 5000;
    private final double score;
    protected final PublicProjectId project;
    protected final SearchSource source;
    protected final List<SearchToken> tokens;

    protected SearchHitBase(SearchSource source, List<SearchToken> searchTokens, PublicProjectId project) {
        this.source = source;
        this.tokens = searchTokens;
        this.project = project;
        int distance = SearchQuery.tokenDistance(searchTokens);
        int weightSum = searchTokens.stream().mapToInt(SearchToken::getSignificance).sum();
        this.score = weightSum * 5000 + Math.max(0, 5000 - distance);
    }

    @Override
    public int compareTo(SearchHitBase other) {
        int scoreCompare = Double.compare(other.score, this.score);
        if (scoreCompare != 0) {
            return scoreCompare;
        }
        return this.source.getSourceName().compareTo(other.source.getSourceName());
    }

    public abstract @Nullable SearchResult createSearchResult() throws StorageException;

    public int hashCode() {
        return Objects.hash(this.project, this.source.getSourceName(), this.source.getSourceType());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileSearchHit)) {
            return false;
        }
        FileSearchHit other = (FileSearchHit)obj;
        return this.project.equals((Object)other.project) && this.source.getSourceName().equals(other.source.getSourceName()) && this.source.getSourceType() == other.source.getSourceType();
    }

    public SearchSource getSource() {
        return this.source;
    }
}

