/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.trigger.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompiler;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.system.trigger.debug.TriggerGraphSliceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@Path(value="api/projects/{project}/triggers/debug/graph-json")
public class TriggerGraphJsonService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get trigger graph as JSON", description="Returns a plain text GraphViz DOT description of the trigger graph", tags={"Administration"})
    public TriggerGraphNode[] getTriggerGraphDot(@Parameter(description="Whether read/written indexes are included as nodes in the graph.") @QueryParam(value="include-indexes") boolean includeIndexes, @Parameter(description="Names of nodes in the graph that should be used to start slicing. This can be trigger names or index names. To slice by index, use the index name, not the index-class name (e.g., check-phase-dependencies, not CheckPhaseResultDependencyIndex). All nodes that are not forward/backward reachable from these nodes are not displayed.Nodes are matched exact, so provide the exact names of triggers/indexes that you want to be included.If the list is empty, the complete graph is returned.") @QueryParam(value="slice-nodes") List<String> sliceNodes, @Parameter(description="If true (forward slicing), only nodes influenced by the slice nodes are returned (i.e., nodes that are executed \"after\" the slice nodes). If false (backward slicing), we return only nodes that influence one of the slice nodes.") @QueryParam(value="forward-slice") boolean forwardSlice) throws TriggerCompilationException, StorageException {
        return this.createTriggerGraph(includeIndexes, this.loadTriggers(sliceNodes, forwardSlice));
    }

    private List<AnalysisTrigger> loadTriggers(List<String> sliceNodes, boolean forwardSlice) throws StorageException, TriggerCompilationException {
        PairList rawTriggers = this.openProjectIndex(TriggerIndex.class, null).getAllTriggers();
        List<AnalysisTrigger> triggers = new TriggerCompiler(this.getProjectStorageSystem().getSchema(), this.getGlobalStorageSystem().getSchema()).compile(rawTriggers);
        if (!sliceNodes.isEmpty()) {
            triggers = TriggerGraphSliceService.limitToSlice(triggers, sliceNodes, forwardSlice);
        }
        return triggers;
    }

    private TriggerGraphNode[] createTriggerGraph(boolean includeIndexes, List<AnalysisTrigger> triggers) {
        TwoDimHashMap storeNameToWritingTriggerNames = new TwoDimHashMap();
        TwoDimHashMap triggerToReadingStoreDependencies = new TwoDimHashMap();
        for (AnalysisTrigger trigger : triggers) {
            for (String storeName : trigger.getWriteStores()) {
                storeNameToWritingTriggerNames.putValue((Object)storeName, (Object)trigger.getName(), (Object)EDependencyType.WRITE);
            }
            if (!includeIndexes) continue;
            for (String storeName : CollectionUtils.sort((Collection)trigger.getReadOnlyStores())) {
                triggerToReadingStoreDependencies.putValue((Object)trigger.getName(), (Object)storeName, (Object)EDependencyType.READ);
            }
            for (String storeName : CollectionUtils.sort((Collection)trigger.getReadBranchingLayerStores())) {
                triggerToReadingStoreDependencies.putValue((Object)trigger.getName(), (Object)storeName, (Object)EDependencyType.BRANCHING_LAYER);
            }
            for (String storeName : CollectionUtils.sort((Collection)trigger.getExpectedDeltaStoreNames())) {
                triggerToReadingStoreDependencies.putValue((Object)trigger.getName(), (Object)storeName, (Object)EDependencyType.DELTA);
            }
        }
        ArrayList<TriggerGraphNode> nodes = new ArrayList<TriggerGraphNode>();
        TriggerGraphJsonService.addTriggerNodes(triggers, (TwoDimHashMap<String, String, EDependencyType>)storeNameToWritingTriggerNames, nodes, (TwoDimHashMap<String, String, EDependencyType>)triggerToReadingStoreDependencies, includeIndexes);
        if (includeIndexes) {
            this.addTriggerGraphIndexes(nodes, (TwoDimHashMap<String, String, EDependencyType>)storeNameToWritingTriggerNames, (TwoDimHashMap<String, String, EDependencyType>)triggerToReadingStoreDependencies);
        }
        return nodes.toArray(new TriggerGraphNode[0]);
    }

    private void addTriggerGraphIndexes(List<TriggerGraphNode> nodes, TwoDimHashMap<String, String, EDependencyType> storeNameToWritingTriggerNames, TwoDimHashMap<String, String, EDependencyType> triggerToReadingStoreDependencies) {
        HashSet allStores = new HashSet();
        for (String trigger : triggerToReadingStoreDependencies.getFirstKeys()) {
            allStores.addAll(triggerToReadingStoreDependencies.getSecondKeys((Object)trigger));
        }
        allStores.addAll(storeNameToWritingTriggerNames.getFirstKeys());
        IndexSchema schema = this.getProjectStorageSystem().getSchema();
        for (String indexName : schema.getEntryNames()) {
            if (!allStores.contains(indexName)) continue;
            SchemaEntry schemaEntry = schema.getEntry(indexName);
            nodes.add(new TriggerGraphNode(indexName, schemaEntry.getIndexClass(), EGraphNodeType.INDEX, (Map<String, EDependencyType>)storeNameToWritingTriggerNames.getSecondMap((Object)indexName), new HashMap<String, String>()));
        }
    }

    private static void addTriggerNodes(List<AnalysisTrigger> triggers, TwoDimHashMap<String, String, EDependencyType> writers, List<TriggerGraphNode> nodes, TwoDimHashMap<String, String, EDependencyType> usedIndexes, boolean includeIndexes) {
        if (triggers.isEmpty()) {
            return;
        }
        triggers.sort(Comparator.comparing(AnalysisTrigger::getExecutionOrderIndex).thenComparing(AnalysisTrigger::getName));
        for (AnalysisTrigger trigger : triggers) {
            Map<String, String> attributes = TriggerGraphJsonService.getAttributes(trigger);
            Map<String, EDependencyType> parents = TriggerGraphJsonService.getParentDependencies(writers, usedIndexes, includeIndexes, trigger);
            nodes.add(new TriggerGraphNode(trigger.getName(), trigger.getAnalysisStepInitializer().getFullAnalysisStepClassName(), EGraphNodeType.TRIGGER, parents, attributes));
        }
    }

    private static Map<String, EDependencyType> getParentDependencies(TwoDimHashMap<String, String, EDependencyType> writers, TwoDimHashMap<String, String, EDependencyType> usedIndexes, boolean includeIndexes, AnalysisTrigger trigger) {
        HashMap<String, EDependencyType> parents = new HashMap<String, EDependencyType>();
        UnmodifiableMap indexesForTrigger = usedIndexes.getSecondMap((Object)trigger.getName());
        if (indexesForTrigger != null) {
            parents.putAll((Map<String, EDependencyType>)indexesForTrigger);
        }
        if (!includeIndexes) {
            for (String store : trigger.getExpectedDeltaStoreNames()) {
                for (String writingTrigger : CollectionUtils.sort((Collection)writers.getSecondKeys((Object)store))) {
                    parents.put(writingTrigger, EDependencyType.DELTA);
                }
            }
        }
        return parents;
    }

    private static Map<String, String> getAttributes(AnalysisTrigger trigger) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("Execution Order", String.valueOf(trigger.getExecutionOrderIndex()));
        attributes.put("Concurrency", trigger.getConcurrency().name().toLowerCase());
        if (trigger.isPeriodic()) {
            attributes.put("Periodic (seconds)", String.valueOf(trigger.getPeriodSeconds(Integer.MAX_VALUE)));
        }
        return attributes;
    }

    public record TriggerGraphNode(String id, String fullClassName, EGraphNodeType type, Map<String, EDependencyType> parentIds, Map<String, String> attributes) {
    }

    @ExportToTypeScript
    static enum EDependencyType {
        READ,
        WRITE,
        BRANCHING_LAYER,
        DELTA;

    }

    @ExportToTypeScript
    static enum EGraphNodeType {
        TRIGGER,
        INDEX;

    }
}

