/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndexCache;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaCoverageSourceFormParameters;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaIssueRequest;
import com.teamscale.index.testgap.query.TgaRequestAssessmentFormOptions;
import com.teamscale.index.testgap.query.TgaRequestAssessmentOptionsBase;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import com.teamscale.service.testgap.TgaSummary;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collections;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;

@Path(value="api/projects/{project}/issues/{issueId}/tga-summary")
public class IssueTgaSummaryService
extends CrossAnnotationServiceBase {
    private static final String ISSUE_ID_PARAMETER_DESCRIPTION = "ID of the issue to retrieve the TGA summary for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get TGA summary", description="Retrieves the TGA summary for a single issue.", tags={"Test Gap Analysis", "Issues"}, responses={@ApiResponse(responseCode="404", description="The given issue ID could not be found."), @ApiResponse(responseCode="409", description="Multiple issues for the provided ID found")})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @PublicApi(since=ETeamscaleVersion.VERSION_7_6_0)
    public TgaSummary getIssueTgaSummary(@Parameter(description="ID of the issue to retrieve the TGA summary for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @PathParam(value="issueId") String issueId, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TgaCoverageSourceQueryParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentOptions) throws StorageException, NotFoundException {
        return this.processRequest(issueId, issueTgaParameters, (ITgaCoverageSourceParameter)coverageSourceParameters, (TgaRequestAssessmentOptionsBase)assessmentOptions);
    }

    @POST
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get TGA Summary", description="Retrieves the TGA summary for a single issue. Is equivalent to the GET endpoint, but allows to work around too long URLs. However GET should be preferred as the GET request is cachable.", tags={"Test Gap Analysis", "Issues"}, responses={@ApiResponse(responseCode="404", description="The given issue ID could not be found."), @ApiResponse(responseCode="409", description="Multiple issues for the provided ID found")})
    @PublicApi(since=ETeamscaleVersion.VERSION_7_6_0, deprecatedSince=ETeamscaleVersion.VERSION_2024_7_0)
    @Consumes(value={"application/x-www-form-urlencoded"})
    public TgaSummary postIssueTgaSummary(@Parameter(description="ID of the issue to retrieve the TGA summary for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @PathParam(value="issueId") String issueId, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TgaCoverageSourceFormParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentFormOptions filterOptions) throws StorageException, NotFoundException {
        return this.processRequest(issueId, issueTgaParameters, (ITgaCoverageSourceParameter)coverageSourceParameters, (TgaRequestAssessmentOptionsBase)filterOptions);
    }

    private TgaSummary processRequest(String issueId, IssueTgaParameters issueTgaParameters, ITgaCoverageSourceParameter coverageSourceParameters, TgaRequestAssessmentOptionsBase assessmentOptions) throws StorageException, NotFoundException {
        this.checkCrossAnnotationPermissions(coverageSourceParameters);
        TeamscaleIssueId actualIssueId = ((TeamscaleIssue)IssueUtils.getSingleIssueForId((IssueIndexBase)((IssueIndexBase)this.openProjectIndex(IssueIndex.class, null)), (String)issueId, (boolean)true).orElseThrow(() -> new NotFoundException("Unknown issue with ID '" + issueId + "'."))).getId();
        RepositoryCommitIssueMappingIndexCache mappingIndexCache = TgaRequestUtils.createAndPreloadIssueMappingCache(Collections.singletonList(actualIssueId), (CommitResolvingStorageSystem)this.serviceInfo.getProjectStorageSystem());
        ETgaAssessmentType assessmentType = assessmentOptions.getAssessmentType();
        TgaIssueRequest request = TgaIssueRequest.createRequest((TeamscaleIssueId)actualIssueId, (ITgaCoverageSourceParameter)coverageSourceParameters, (IssueTgaParameters)issueTgaParameters, (ETgaAssessmentType)assessmentType, (RepositoryCommitIssueMappingIndexCache)mappingIndexCache, (IndexLayer)this.serviceInfo.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId());
        AssessedTgaData assessedData = request.fetchAndAssessData();
        return new TgaSummary(assessmentType, (CounterSet<ETestGapState>)TgaAggregationUtils.countStates((AssessedTgaData)assessedData));
    }
}

