/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github.event_handler;

import com.teamscale.core.authenticate.github.dto.Installation;
import com.teamscale.core.authenticate.github.dto.InstallationRepository;
import com.teamscale.core.authenticate.github.index.GitHubInstallationIndex;
import com.teamscale.core.authenticate.github.index.LongKey;
import com.teamscale.core.authenticate.github.index.OrgOrUserInstallationsKey;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.webhook.github.data.InstallationEventPayload;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerBase;
import java.util.List;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.intellij.lang.annotations.Language;

class GitHubAppInstallationEventHandler
extends GitHubWebhookEventHandlerBase {
    private final String gitHubServerUrl;

    GitHubAppInstallationEventHandler(IndexLayer indexLayer, String gitHubServerUrl) {
        super(indexLayer);
        this.gitHubServerUrl = gitHubServerUrl;
    }

    @Override
    public void handle(@Language(value="JSON") String eventPayload) throws StorageException, JsonSerializationException {
        InstallationEventPayload installationPayload = (InstallationEventPayload)JsonUtils.deserializeFromJson((String)eventPayload, InstallationEventPayload.class);
        String action = installationPayload.action();
        if ("new_permissions_accepted".equals(action)) {
            return;
        }
        GitHubInstallationIndex installationIndex = (GitHubInstallationIndex)this.indexLayer.openGlobalIndex(GitHubInstallationIndex.class);
        Installation installation = installationPayload.installation();
        OrgOrUserInstallationsKey orgOrUserInstallationsKey = new OrgOrUserInstallationsKey(this.gitHubServerUrl, installation.getAccountName());
        List availableRepositories = CollectionUtils.map((Object[])installationPayload.repositories(), InstallationRepository::getFullName);
        switch (installationPayload.action()) {
            case "created": {
                installationIndex.addInstallation(orgOrUserInstallationsKey, new LongKey(installation.getId()), installation.getAppId(), availableRepositories);
                break;
            }
            case "deleted": {
                installationIndex.removeInstallation(orgOrUserInstallationsKey, installation.getId());
                break;
            }
        }
    }
}

