/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.visitors.PHPTreeSubscriber;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S128")
public class NonEmptyCaseWithoutBreakCheck
extends PHPVisitorCheck {
    public static final String KEY = "S128";
    private static final String MESSAGE = "End this switch case with an unconditional break, continue, return or throw statement.";

    @Override
    public void visitSwitchStatement(SwitchStatementTree switchTree) {
        SwitchCaseClauseTree currentClause = null;
        for (SwitchCaseClauseTree nextClause : switchTree.cases()) {
            if (!(currentClause == null || NonEmptyCaseWithoutBreakCheck.isEmpty(currentClause) || NonEmptyCaseWithoutBreakCheck.hasJumpStatement(currentClause) || NonEmptyCaseWithoutBreakCheck.hasNoBreakComment(nextClause))) {
                this.context().newIssue(this, currentClause.caseToken(), currentClause.caseSeparatorToken(), MESSAGE);
            }
            currentClause = nextClause;
        }
        super.visitSwitchStatement(switchTree);
    }

    private static boolean hasNoBreakComment(SwitchCaseClauseTree caseClause) {
        return !caseClause.caseToken().trivias().isEmpty();
    }

    private static boolean hasJumpStatement(SwitchCaseClauseTree caseClause) {
        List<StatementTree> statements = caseClause.statements();
        if (statements.get(statements.size() - 1).is(Tree.Kind.BREAK_STATEMENT)) {
            return true;
        }
        return JumpStatementFinder.hasJumpStatement(caseClause);
    }

    private static boolean isEmpty(SwitchCaseClauseTree caseClause) {
        return caseClause.statements().isEmpty();
    }

    private static class JumpStatementFinder
    extends PHPTreeSubscriber {
        private boolean foundNode = false;

        private JumpStatementFinder() {
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return Arrays.asList(Tree.Kind.FUNCTION_CALL, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.GOTO_STATEMENT);
        }

        @Override
        public void visitNode(Tree tree) {
            if (tree.is(Tree.Kind.FUNCTION_CALL) && !CheckUtils.isExitExpression((FunctionCallTree)tree)) {
                return;
            }
            this.foundNode = true;
        }

        public static boolean hasJumpStatement(Tree tree) {
            JumpStatementFinder jumpStatementFinder = new JumpStatementFinder();
            jumpStatementFinder.scanTree(tree);
            return jumpStatementFinder.foundNode;
        }
    }
}

