/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.FunctionCallCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-suspicious-function-call", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SuspiciousFunctionCallCheck
extends FunctionCallCheckBase {
    @CheckOption(name="Suspicious function calls - List of Statements", description="Comma separated list of function module names which are suspicious.")
    private Set<String> suspiciousFunctions = CollectionUtils.asHashSet((Object[])new String[]{"GUI_UPLOAD", "GUI_DOWNLOAD", "FTP_CONNECT"});

    @Override
    protected Set<String> getRelevantFunctionNames() {
        return this.suspiciousFunctions;
    }

    @Override
    protected String buildFindingsMessage(String functionName) {
        return "Call of suspicious function module " + MarkupUtils.formatAsSourceCode((String)functionName);
    }
}

