/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Optional;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-copyright-header-comment", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVASCRIPT, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CopyrightHeaderCommentCheck
extends CheckImplementationBase {
    @CheckOption(name="Copyright Header", description="Company copyright information that should be contained in every code file.", multilineText=true)
    private String multilineCopyrightComment = "/**\n* Sample Copyright Comment.\n*/";
    private static final String FINDING_MESSAGE = "File is not (or incorrectly) copyrighted";
    private String normalizedExpectedComment;

    public void initialize() {
        this.normalizedExpectedComment = CopyrightHeaderCommentCheck.normalizeText(this.multilineCopyrightComment);
    }

    public void execute() throws CheckException {
        Optional<IToken> optionalToken = this.context.getTokens(ECodeViewOption.FILTERED).stream().filter(token -> token.getType() != ETokenType.PREPROCESSOR_DIRECTIVE).findFirst();
        if (optionalToken.isEmpty()) {
            return;
        }
        IToken token2 = optionalToken.get();
        if (token2.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(token2)).createAndStore();
            return;
        }
        if (!this.normalizedExpectedComment.equals(CopyrightHeaderCommentCheck.normalizeText(token2.getText()))) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(token2)).createAndStore();
        }
    }

    private static String normalizeText(String text) {
        String normalizedText = StringUtils.removeWhitespace((String)text);
        return StringUtils.replaceLineBreaks((String)normalizedText, (String)"");
    }
}

