/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.Pair;

@Check(id="cqse-consistent-storage-class-modifier", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ConsistentStorageClassModifierCheck
extends CheckImplementationBase {
    private final Map<String, Pair<ShallowEntity, Boolean>> nameToFirstOccurrenceXLinkage = new HashMap<String, Pair<ShallowEntity, Boolean>>();

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        this.nameToFirstOccurrenceXLinkage.clear();
        List topLevelEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity topLevelEntity : topLevelEntities) {
            if (topLevelEntity.getType() != EShallowEntityType.ATTRIBUTE && topLevelEntity.getType() != EShallowEntityType.METHOD) continue;
            this.processEntity(topLevelEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (entity.getType() == EShallowEntityType.ATTRIBUTE || entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().equals("function declaration")) {
            this.processSimpleDeclaration(entity);
        } else if (entity.getSubtype().equals("function")) {
            this.processFunctionDefinition(entity);
        }
    }

    private void processFunctionDefinition(ShallowEntity entity) throws CheckException {
        this.checkConsistentLinkage(entity.getName(), ConsistentStorageClassModifierCheck.specifyInternalLinkage((List<IToken>)entity.ownStartTokens()), entity);
    }

    private static boolean specifyInternalLinkage(List<IToken> tokens) {
        return TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.STATIC);
    }

    private void processSimpleDeclaration(ShallowEntity entity) throws CheckException {
        List initializerDeclaratorList = TokenStreamUtils.splitWithNesting((List)entity.ownStartTokens(), (ETokenType)ETokenType.COMMA, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LT), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.GT));
        List declaratorSpecifierSequence = (List)initializerDeclaratorList.get(0);
        boolean internalLinkage = ConsistentStorageClassModifierCheck.specifyInternalLinkage(declaratorSpecifierSequence);
        this.checkConsistentLinkage(entity.getName(), internalLinkage, entity);
        for (List iTokenList : initializerDeclaratorList.subList(1, initializerDeclaratorList.size())) {
            int index = TokenStreamUtils.firstTokenMatching((List)iTokenList, (ITokenMatcher)ETokenType.IDENTIFIER);
            if (index == -1) continue;
            String name = ((IToken)iTokenList.get(index)).getText();
            this.checkConsistentLinkage(name, internalLinkage, entity);
        }
    }

    private void checkConsistentLinkage(String name, boolean internalLinkage, ShallowEntity entity) throws CheckException {
        if (this.nameToFirstOccurrenceXLinkage.containsKey(name)) {
            Pair<ShallowEntity, Boolean> entityIsInternalPair = this.nameToFirstOccurrenceXLinkage.get(name);
            if (!((Boolean)entityIsInternalPair.getSecond()).equals(internalLinkage)) {
                this.createFindingForSiblingEntities("`" + name + "` has conflicting linkage declarations", Arrays.asList((ShallowEntity)entityIsInternalPair.getFirst(), entity));
            }
        } else {
            this.nameToFirstOccurrenceXLinkage.put(name, (Pair<ShallowEntity, Boolean>)new Pair((Object)entity, (Object)internalLinkage));
        }
    }
}

