/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.switches;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CppLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

public class CppNoreturnMethodExtractorPhase
implements IGlobalExtractionPhase<MethodNameValue, String> {
    public List<MethodNameValue> extract(ITokenElementContext fileContext) throws CheckException {
        List allMethods = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive((Collection)fileContext.getRootEntity(ECodeViewOption.FILTERED_PREPROCESSED).getChildren(), (EShallowEntityType)EShallowEntityType.METHOD);
        return CollectionUtils.filterAndMap((Collection)allMethods, arg_0 -> ((CppLanguageFeatureParser)LanguageFeatureParser.CPP).isNoreturn(arg_0), entity -> new MethodNameValue(fileContext.getUniformPath(), entity.getName()));
    }

    public MethodNameValue createValue(String uniformPath, String value, String additionalInformation) {
        return new MethodNameValue(uniformPath, value);
    }

    public EnumSet<ELanguage> getLanguages() {
        return LanguageGroups.C_CPP_AND_MS_CLI;
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    @IndexValueClass
    public static class MethodNameValue
    implements IExtractedValue<String> {
        private final String methodName;
        private final String uniformPath;

        private MethodNameValue(String uniformPath, String methodName) {
            this.methodName = methodName;
            this.uniformPath = uniformPath;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.methodName;
        }

        public String getAdditionalInformation() {
            return "";
        }
    }
}

