/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-use-literals-where-appropriate", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UseLiteralsWhereAppropriate
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> CS_ACCESS_MODIFIERS = EnumSet.of(ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.INTERNAL, ETokenType.PRIVATE);

    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            if (!attribute.getSubtype().equals("attribute") || !TokenStreamUtils.containsAll((List)attribute.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.STATIC, ETokenType.READONLY})) continue;
            this.processEntity(attribute);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        int eqIndex = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.EQ);
        if (eqIndex == -1) {
            return;
        }
        if (!UseLiteralsWhereAppropriate.isInternalMember((List<IToken>)tokens.subList(0, eqIndex - 1))) {
            return;
        }
        if (eqIndex + 2 >= tokens.size()) {
            return;
        }
        IToken nextToken = (IToken)tokens.get(eqIndex + 1);
        ETokenType nextTokenType = nextToken.getType();
        if (nextTokenType.getTokenClass() != ETokenType.ETokenClass.LITERAL) {
            return;
        }
        if (nextToken.getText().charAt(0) == '$') {
            return;
        }
        IToken nextNextToken = (IToken)tokens.get(eqIndex + 2);
        if (nextNextToken.getType() == ETokenType.SEMICOLON) {
            this.buildFinding("Field `" + entity.getName() + "` can be constant", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }

    private static boolean isInternalMember(List<IToken> tokens) {
        if (!TokenStreamUtils.containsAny(tokens, CS_ACCESS_MODIFIERS)) {
            return true;
        }
        if (TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.PRIVATE)) {
            return true;
        }
        return TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.INTERNAL) && !TokenStreamUtils.contains(tokens, (ETokenType)ETokenType.PROTECTED);
    }
}

