/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-test-class-naming-convention", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class TestClassNamingConventionCheck
extends CheckImplementationBase {
    @CheckOption(name="Test class naming convention: naming pattern", description="The name of a test class has to match this regular expression.")
    private String nameRegex = "^.*Test$";
    private Pattern namePattern;

    public void initialize() {
        this.namePattern = Pattern.compile(this.nameRegex);
    }

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (LanguageFeatureParser.JAVA.isTestClass(entity) && !TestClassNamingConventionCheck.isAbstractClass(entity) && !TestClassNamingConventionCheck.isNestedTestClass(entity) && entity.getName() != null && !this.namePattern.matcher(entity.getName()).matches()) {
            this.buildFinding("The class `" + entity.getName() + "` does not match the pattern `" + this.nameRegex + "`", this.buildLocation().forLine(entity.getStartLine(), ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
        }
    }

    private static boolean isNestedTestClass(ShallowEntity entity) {
        UnmodifiableList parentsChildren = entity.getParent().getChildren();
        int indexOfEntityInParentsChildren = parentsChildren.indexOf(entity);
        return indexOfEntityInParentsChildren != 0 && "Nested".equals(((ShallowEntity)parentsChildren.get(indexOfEntityInParentsChildren - 1)).getName());
    }

    private static boolean isAbstractClass(ShallowEntity entity) {
        return TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.ABSTRACT);
    }
}

