/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.jc_0604", languages={ELanguage.SIMULINK})
public class SimulinkBlockShadowVisibilityCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION_TURN_OFF = FindingPropertyList.singleton((String)"Recommended Action", (String)"Turn off the block shadow.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!"on".equals(block.getParameter("DropShadow"))) continue;
            this.buildFinding("Block shadow is visible but shall be turned off", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_TURN_OFF).createAndStore();
        }
    }
}

