/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0610", languages={ELanguage.SIMULINK})
public class SimulinkProductBlockInputsCheck
extends CheckImplementationBase {
    @CheckOption(name="Product blocks - Force multiplication as first input (jc_0610_a)", description="If set, the first inputs of Product blocks shall use multiplication.")
    private boolean forceMultiplicationAsFirstInput = true;
    @CheckOption(name="Product blocks - Disallow more than two inputs (jc_0610_b)", description="If set, more than two input parameters of Product blocks are disallowed.")
    private boolean disallowMoreThanTwoInputs = true;
    private static final FindingPropertyList RECOMMENDED_ACTION_NON_MULTIPLICATION_FIRST_INPUT = FindingPropertyList.singleton((String)"Recommended Action", (String)"Reorder the parameters in a way to ensure that the first input is a multiplication.");
    private static final FindingPropertyList RECOMMENDED_ACTION_MORE_THAN_TWO_INPUTS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Split up the Product block into multiple blocks to reduce the number of inputs.");

    public void execute() {
        if (!this.forceMultiplicationAsFirstInput && !this.disallowMoreThanTwoInputs) {
            return;
        }
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("Product"), (boolean)false, (boolean)false)) {
            this.checkBlock(block);
        }
    }

    private void checkBlock(SimulinkBlock block) {
        String inputs = block.getParameter("Inputs");
        if (StringUtils.isEmpty((String)inputs)) {
            return;
        }
        if (this.forceMultiplicationAsFirstInput && SimulinkProductBlockInputsCheck.isOperatorSequence(inputs) && inputs.charAt(0) != '*') {
            this.buildFinding("Product block uses invalid operator for first input", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_NON_MULTIPLICATION_FIRST_INPUT).createAndStore();
        }
        int inPortsSize = block.getInPorts().size();
        if (this.disallowMoreThanTwoInputs && inPortsSize > 2) {
            this.buildFinding("Product block has more than 2 inputs", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_MORE_THAN_TWO_INPUTS).createAndStore();
        }
    }

    private static boolean isOperatorSequence(String inputs) {
        return inputs.contains("*") || inputs.contains("/");
    }
}

