/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.datahandler.simulink.SimulinkLineLayoutUtils;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.na_0009", languages={ELanguage.SIMULINK})
public class SimulinkSignalPropagatedLabelCheck
extends CheckImplementationBase {
    @CheckOption(name="Non-transformative block types", description="Blocks which do not transform a signal. If the block is also configured as being transformative, the other option will take precedence. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> nonTransformativeBlocks = Set.of("EnablePort", "From", "FunctionCallSplit", "Goto", "SignalSpecification", "SubSystem", "Reference", "TriggerPort", "Inport");
    @CheckOption(name="Transformative block types", description="Blocks which transform a signal. Blocks defined as transformative take precedence over blocks entered as non-transformative. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).", multilineText=true)
    private Set<String> transformativeBlocks = new HashSet<String>();
    private static final String FINDING_MESSAGE_ENTERED_LABEL = "Signal label entered instead of being propagated";
    private static final FindingPropertyList RECOMMENDED_ACTION_ENTERED_LABEL = FindingPropertyList.singleton((String)"Recommended Action", (String)"Signal labels shall be propagated instead of being entered");
    private static final String FINDING_MESSAGE_PROPAGATED_LABEL = "Signal label propagated instead of being entered";
    private static final FindingPropertyList RECOMMENDED_ACTION_PROPAGATED_LABEL = FindingPropertyList.singleton((String)"Recommended Action", (String)"Signal labels shall be entered instead of being propagated");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        ListMap findingLinesPerSourcePort = new ListMap();
        SimulinkPropagatedSignalLabels propagatedSignalLabels = this.context.getSimulinkContext().getPropagatedSimulinkSignalLabelsForFile().orElse(null);
        for (SimulinkLine line : model.getContainedLinesRecursively(false, false)) {
            String labelText;
            SimulinkOutPort srcPort;
            if (!SimulinkUtils.isUserVisible((SimulinkLine)line) || (srcPort = line.getSrcPort()) == null || (labelText = SimulinkLineLayoutUtils.determineLineLabelText((SimulinkLine)line, (SimulinkPropagatedSignalLabels)propagatedSignalLabels)) == null) continue;
            findingLinesPerSourcePort.add((Object)srcPort, (Object)line);
        }
        for (SimulinkOutPort srcPort : findingLinesPerSourcePort.getKeys()) {
            SimulinkLine line;
            List lines = (List)findingLinesPerSourcePort.getCollection((Object)srcPort);
            lines.sort(SimulinkUtils.LINE_BY_DST_PORT_COMPARATOR);
            Iterator iterator = lines.iterator();
            while (iterator.hasNext() && !this.checkLabels(line = (SimulinkLine)iterator.next(), srcPort)) {
            }
        }
    }

    private boolean checkLabels(SimulinkLine line, SimulinkOutPort srcPort) {
        if (line.getName().isPresent()) {
            return this.checkEnteredLabels(line, srcPort);
        }
        return this.checkPropagatedLabels(line, srcPort);
    }

    private boolean checkEnteredLabels(SimulinkLine line, SimulinkOutPort srcPort) {
        SimulinkBlock srcBlock = srcPort.getBlock();
        boolean fromTransformative = this.blockTypeIsTransformative(srcBlock.getType());
        boolean fromRoot = SimulinkUtils.isInport((SimulinkBlock)srcBlock) && line.getContainer().getParent() == null;
        boolean fromLibrarySubsystem = srcBlock.isOfType("Reference");
        boolean fromInportInLibrarySubsystem = this.isFromInportBlockInLibrarySubsystem(line);
        if (!(fromTransformative || fromRoot || fromLibrarySubsystem || fromInportInLibrarySubsystem)) {
            this.buildFinding(FINDING_MESSAGE_ENTERED_LABEL, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_ENTERED_LABEL).createAndStore();
            return true;
        }
        return false;
    }

    private boolean checkPropagatedLabels(SimulinkLine line, SimulinkOutPort srcPort) {
        SimulinkBlock srcBlock = srcPort.getBlock();
        boolean fromNonTransformative = !this.blockTypeIsTransformative(srcBlock.getType());
        boolean isNotInRoot = line.getContainer().getParent() != null;
        boolean fromNonRootInport = srcBlock.isOfType("Inport") && isNotInRoot;
        boolean fromSubSystemOrStateflowChart = srcBlock.isOfType("SubSystem") || srcBlock instanceof StateflowBlock;
        boolean fromInportInLibrarySubsystem = this.isFromInportBlockInLibrarySubsystem(line);
        if (!fromNonTransformative && !fromNonRootInport && !fromSubSystemOrStateflowChart || fromInportInLibrarySubsystem) {
            this.buildFinding(FINDING_MESSAGE_PROPAGATED_LABEL, (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION_PROPAGATED_LABEL).createAndStore();
            return true;
        }
        return false;
    }

    private boolean blockTypeIsTransformative(String blockType) {
        return this.transformativeBlocks.contains(blockType) || !this.nonTransformativeBlocks.contains(blockType);
    }

    private boolean isFromInportBlockInLibrarySubsystem(SimulinkLine line) {
        SimulinkOutPort srcPort = line.getSrcPort();
        if (srcPort == null) {
            return false;
        }
        SimulinkBlock srcBlock = srcPort.getBlock();
        if (!srcBlock.isOfType("Inport") && !srcBlock.isOfType("InportShadow")) {
            return false;
        }
        SimulinkBlock parent = srcBlock.getParent();
        return parent.isOfType("SubSystem") && parent.getParent().isOfType("Model") && ((SimulinkModel)parent.getParent()).isLibraryModel();
    }
}

