/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.WorkItemLocationBuilder;
import eu.cqse.check.wia.parsable.rule.TypedSetRule;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class KeywordCheckUtils {
    public static Pattern compileIgnorePattern(Collection<String> ignorePatterns) {
        StringJoiner combinedIgnorePattern = new StringJoiner(")|(", "(", ")");
        ignorePatterns.forEach(combinedIgnorePattern::add);
        return Pattern.compile(combinedIgnorePattern.toString());
    }

    public static void executeKeywordSetCheck(SpecItem check, String findingMessagePrefix, BiFunction<String, Optional<? extends ElementLocation>, CheckFindingBuilderBase> buildFinding, WorkItemDescriberBase<SpecItem> describer, Set<TypedSetRule<String>> parsedLanguageRules, Set<String> keywords, WorkItemLocationBuilder locationBuilder, List<String> ignorePattern) {
        Pattern compiledIgnorePattern = KeywordCheckUtils.compileIgnorePattern(ignorePattern);
        for (TypedSetRule<String> languageRule : parsedLanguageRules) {
            if (!languageRule.matches(check)) continue;
            if (languageRule.values.contains("ALL")) {
                List fieldNames = describer.getNonTechnicalKeys((TeamscaleIssue)check);
                for (String fieldName : fieldNames) {
                    KeywordCheckUtils.checkKeywordViolation(check, findingMessagePrefix, compiledIgnorePattern, fieldName, keywords, buildFinding, locationBuilder, (WorkItemDescriberBase.IValueDescriber<SpecItem>)describer.getValueDescriber(fieldName));
                }
                continue;
            }
            for (String fieldName : languageRule.values) {
                KeywordCheckUtils.checkKeywordViolation(check, findingMessagePrefix, compiledIgnorePattern, fieldName, keywords, buildFinding, locationBuilder, (WorkItemDescriberBase.IValueDescriber<SpecItem>)describer.getValueDescriber(fieldName));
            }
        }
    }

    private static void checkKeywordViolation(SpecItem item, String findingMessagePrefix, Pattern compiledIgnorePattern, String fieldName, Set<String> keywords, BiFunction<String, Optional<? extends ElementLocation>, CheckFindingBuilderBase> buildFinding, WorkItemLocationBuilder locationBuilder, WorkItemDescriberBase.IValueDescriber<SpecItem> valueDescriber) {
        String fieldValue = valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED);
        if (StringUtils.isEmpty((String)fieldValue)) {
            return;
        }
        fieldValue = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)compiledIgnorePattern, (String)fieldValue).toLowerCase();
        for (String keyword : keywords) {
            int wordLength = keyword.length();
            int keywordIndex = fieldValue.indexOf(keyword);
            while (keywordIndex >= 0) {
                if (SimpleNLPUtils.hasWordBoundaries((int)keywordIndex, (int)wordLength, (String)fieldValue)) {
                    buildFinding.apply(KeywordCheckUtils.buildFindingMessage(findingMessagePrefix, keyword), locationBuilder.forAttribute(valueDescriber.getExactKeyName((TeamscaleIssue)item), valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.RAW))).addFindingProperties(KeywordCheckUtils.buildProperties(item, fieldName, keyword)).createAndStore();
                }
                keywordIndex = fieldValue.indexOf(keyword, keywordIndex + wordLength);
            }
        }
    }

    private static String buildFindingMessage(String checkPrefix, String keyword) {
        return checkPrefix + ": '" + MarkupUtils.escapeMarkdownRelevantSymbols((String)keyword) + "'";
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem specItem, String violatedField, String keyword) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)specItem.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        properties.addProperty("Expression", (Object)keyword);
        return properties;
    }

    private KeywordCheckUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

