/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedMultiMapRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-wia-max-word-count", languages={ELanguage.NL_TESTS, ELanguage.NL_REQUIREMENTS})
public class MaxWordCountCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "Max Word Count Per Field";
    @CheckOption(name="Max Word Count Per Field - Rules", description="List of word count rules separated by comma or new-line.\nA single word count rule has the format:\n\n`<itemTypes> -> <maxFieldLengths>`\n\n`<itemTypes>` is a `|` seperated list of item types (e.g. `Requirement`, `Test Case`, `Manual Test Case`, etc.) or also their abbreviations (e.g `REG`, `TC`, `MTC`, etc.)\n\n`<maxFieldLengths>` is a `|` or '+' separated list of field rules, where each field rule has the format <field1>[|<field2>]*:<maxFieldLength>, mapping field names to integers representing the maximum number of words allowed in each field.\n\n`ANY` is a keyword that matches any `ItemType`.\n\nHere are some example rules:\n\n`Requirement -> Description:40 + Acceptance Criteria:30` implies that the item of type `Requirement` must not contain more than `40` words in `Description` and `30` words in `Acceptance Criteria`.\n\n`Requirement -> Description | Acceptance Criteria:20` implies that the item of type `Requirement` must not contain more than `20` words in `Description` or `Acceptance Criteria` fields.\n\n`Test Case|Requirement -> Test Step:20 + Fail State:30` implies item of the types `Test Case` or `Requirement` must not contain more than `20` words in `Test Step` and `30` words in `Fail State`.\n\n`ANY -> Description:40` implies that any item type must not contain more than `40` words in `Description`.\n\n`ANY -> ALL:50` implies that any item type must not contain more than `50` words in any field.\n", multilineText=true)
    private Set<String> rawMaxWordRules = Collections.emptySet();
    private final Set<TypedMultiMapRule<String, Integer>> parsedMaxWordCountRules = new HashSet<TypedMultiMapRule<String, Integer>>();
    private static final TypedMultiMapRule.Parser<String, Integer> PARSER = new TypedMultiMapRule.Parser().withKeyParser(ParsableRule.RuleParser.TO_STRING).withValueParser(ParsableRule.RuleParser.TO_POSITIVE);

    public MaxWordCountCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        for (String rawRule : this.rawMaxWordRules) {
            this.parsedMaxWordCountRules.add((TypedMultiMapRule<String, Integer>)PARSER.parse(rawRule));
        }
    }

    @Override
    protected void execute(SpecItem item) throws CheckException {
        for (TypedMultiMapRule<String, Integer> rule : this.parsedMaxWordCountRules) {
            if (!rule.matches(item)) continue;
            if (rule.map.containsKey("ALL")) {
                int value = (Integer)rule.map.get("ALL");
                for (String field : this.getDescriber((TeamscaleIssue)item).getNonTechnicalKeys((TeamscaleIssue)item)) {
                    this.checkViolation(item, field, value);
                }
                continue;
            }
            for (Map.Entry entry : rule.map.entrySet()) {
                this.checkViolation(item, (String)entry.getKey(), (Integer)entry.getValue());
            }
        }
    }

    private void checkViolation(SpecItem item, String field, int maxWords) {
        WorkItemDescriberBase.IValueDescriber valueDescriber = this.getDescriber((TeamscaleIssue)item).getValueDescriber(field);
        String fieldValueWithoutHtml = StringUtils.emptyIfNull((String)valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED));
        int actualWords = SimpleNLPUtils.splitIntoWords((String)fieldValueWithoutHtml).size();
        if (actualWords <= maxWords) {
            return;
        }
        int exceededWords = actualWords - maxWords;
        String rawFieldValue = StringUtils.emptyIfNull((String)valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.RAW));
        this.buildFinding(MaxWordCountCheck.buildFindingMessage(maxWords, actualWords), this.buildLocation().forAttribute(valueDescriber.getExactKeyName((TeamscaleIssue)item), rawFieldValue)).addFindingProperties(MaxWordCountCheck.buildProperties(item, field, exceededWords)).createAndStore();
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem specItem, String violatedField, int exceededWords) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)specItem.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        properties.addProperty("Exceeded Words", (Object)exceededWords);
        return properties;
    }

    private static String buildFindingMessage(int maxWordsLimit, int words) {
        return String.format("Violation of field length threshold (number of words) of %d: %d", maxWordsLimit, words);
    }
}

