/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ManualTestCase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.SimpleNLPUtils;

@Check(id="cqse-wia-no-vague-expressions", languages={ELanguage.NL_TESTS})
public class NoVagueExpressionsCheck
extends WorkItemCheckBase<ManualTestCase> {
    private static final String CHECK_NAME = "No vague expressions in test steps";
    @CheckOption(name="No vague expressions in test steps - Dictionary", description="Comma separated list of expressions that are considered vague.")
    private Set<String> vagueWords = Set.of("about", "adequate", "adequately", "approximate", "approximately", "around", "bad", "best", "better", "between", "can", "clear", "clearly", "close", "could", "e.g.", "easily", "easy", "effective", "effectively", "efficient", "efficiently", "etc", "far", "fast", "for example", "for instance", "good", "having in mind", "high", "ideal", "ideally", "least", "like", "low", "may", "maybe", "might", "mostly", "recent", "recently", "relevant", "same", "should", "significant", "significantly", "similar", "similarly", "slow", "so as", "strong", "take into account", "take into consideration", "useful", "worse", "would");
    @CheckOption(name="No vague expressions in test steps - Text ignore patterns (regex)", description="A list of comma separated Java regex patterns for text parts that are ignored and\nnot included in the detection of this check.\nFor example, the regex `\".*?\"` ignores text that is enclosed in double quotes.\n")
    private List<String> ignorePatterns = List.of("\".*?\"", "(?<=\\W|^)'.*?'");
    private Pattern compiledIgnorePattern;

    public NoVagueExpressionsCheck() {
        super(ManualTestCase.class);
    }

    private void checkForWords(ManualTestCase testCase, ManualTestCase.TestStep step, String text, boolean isAction) {
        text = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)this.compiledIgnorePattern, (String)text.toLowerCase());
        for (String vagueWord : this.vagueWords) {
            int wordLength = vagueWord.length();
            int index = text.indexOf(vagueWord);
            while (index >= 0) {
                if (SimpleNLPUtils.hasWordBoundaries((int)index, (int)wordLength, (String)text)) {
                    this.buildFinding("Vague expression '" + vagueWord + "'", this.buildLocation().forTestStep(testCase, step, index, index + wordLength - 1, isAction)).createAndStore();
                }
                index = text.indexOf(vagueWord, index + wordLength);
            }
        }
    }

    public void initialize() throws CheckException {
        StringJoiner combinedPattern = new StringJoiner(")|(", "(", ")");
        this.ignorePatterns.forEach(combinedPattern::add);
        this.compiledIgnorePattern = Pattern.compile(combinedPattern.toString());
    }

    @Override
    protected void execute(ManualTestCase testCase) throws CheckException {
        for (ManualTestCase.TestStep step : testCase.getTestSteps()) {
            this.checkForWords(testCase, step, step.getAction(), true);
            this.checkForWords(testCase, step, step.getCheck(), false);
        }
    }
}

