/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.webapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.alm.client.utils.StringUtil;

public class ApiResourceVersion {
    private static final String PREVIEW_STAGE_NAME = "preview";
    private Version apiVersion;
    private int resourceVersion;
    private boolean isPreview;

    public ApiResourceVersion() {
        this(new Version(1, 0));
    }

    public ApiResourceVersion(Version apiVersion) {
        this(apiVersion, 0);
    }

    public ApiResourceVersion(Version apiVersion, int resourceVersion) {
        this.apiVersion = apiVersion;
        this.resourceVersion = resourceVersion;
        this.isPreview = resourceVersion > 0;
    }

    public ApiResourceVersion(String apiResourceVersionString) {
        this.toVersion(apiResourceVersionString);
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersionString() {
        return this.apiVersion.toString();
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersionString(String apiVersionString) {
        this.apiVersion = StringUtil.isNullOrEmpty(apiVersionString) ? new Version(1, 0) : new Version(apiVersionString);
    }

    public Version getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(Version apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="resourceVersion")
    public int getResourceVersion() {
        return this.resourceVersion;
    }

    @JsonProperty(value="resourceVersion")
    public void setResourceVersion(int resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @JsonProperty(value="IsPreview")
    public boolean isPreview() {
        return this.isPreview;
    }

    @JsonProperty(value="IsPreview")
    public void setPreview(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public String toString() {
        StringBuilder sbVersion = new StringBuilder(this.apiVersion.toString());
        if (this.isPreview) {
            sbVersion.append('-');
            sbVersion.append(PREVIEW_STAGE_NAME);
            if (this.resourceVersion > 0) {
                sbVersion.append('.');
                sbVersion.append(this.resourceVersion);
            }
        }
        return sbVersion.toString();
    }

    private void toVersion(String apiResourceVersionString) {
        if (StringUtil.isNullOrEmpty(apiResourceVersionString)) {
            throw new IllegalArgumentException("ApiVersion: is null or empty");
        }
        String[] apiResourceVersionParts = apiResourceVersionString.split("-");
        if (apiResourceVersionParts.length == 2 && !this.tryParsePreview(apiResourceVersionParts[1])) {
            throw new IllegalArgumentException("ApiVersion: " + apiResourceVersionString);
        }
        if (!this.tryParseVersion(apiResourceVersionParts[0])) {
            throw new IllegalArgumentException("ApiVersion: " + apiResourceVersionString);
        }
    }

    private boolean tryParseVersion(String apiVersion) {
        try {
            this.apiVersion = new Version(apiVersion);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean tryParsePreview(String previewVersion) {
        String[] previewParts = previewVersion.split("\\.");
        if (previewParts.length == 2) {
            try {
                this.resourceVersion = Integer.parseInt(previewParts[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (previewParts.length > 0 && PREVIEW_STAGE_NAME.equalsIgnoreCase(previewParts[0])) {
            this.isPreview = true;
            return true;
        }
        return false;
    }

    public static class Version
    implements Comparable<Version> {
        final int major;
        final int minor;

        public Version(int major) {
            this(major, 0);
        }

        public Version(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public Version(String version) {
            String sMinor;
            String sMajor;
            int n = version.indexOf(46);
            if (n < 0) {
                sMajor = version;
                sMinor = null;
            } else {
                sMajor = version.substring(0, n);
                sMinor = version.substring(n + 1);
            }
            this.major = StringUtil.isNullOrEmpty(sMajor) ? 0 : Integer.parseInt(sMajor);
            this.minor = StringUtil.isNullOrEmpty(sMinor) ? 0 : Integer.parseInt(sMinor);
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        @Override
        public int compareTo(Version v) {
            if (v == null) {
                return 1;
            }
            if (this.major < v.getMajor()) {
                return -1;
            }
            if (this.major > v.getMajor()) {
                return 1;
            }
            if (this.minor < v.getMinor()) {
                return -1;
            }
            if (this.minor > v.getMinor()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.major) + "." + String.valueOf(this.minor);
        }
    }
}

