/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.events;

import com.microsoft.tfs.core.clients.CoreClientEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.util.Check;

public class CheckinEvent
extends CoreClientEvent {
    static final long serialVersionUID = 7689380099998635255L;
    private final Workspace workspace;
    private final int changesetID;
    private final PendingChange[] committedChanges;
    private final PendingChange[] undoneChanges;

    public CheckinEvent(EventSource source, Workspace workspace, int changesetID, PendingChange[] committedChanges, PendingChange[] undoneChanges) {
        super(source);
        Check.notNull(source, "source");
        Check.notNull(workspace, "workspace");
        Check.notNull(committedChanges, "committedChanges");
        Check.notNull(undoneChanges, "undoneChanges");
        this.workspace = workspace;
        this.changesetID = changesetID;
        this.committedChanges = (PendingChange[])committedChanges.clone();
        this.undoneChanges = (PendingChange[])undoneChanges.clone();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public int getChangesetID() {
        return this.changesetID;
    }

    public PendingChange[] getCommittedChanges() {
        return this.committedChanges;
    }

    public PendingChange[] getUndoneChanges() {
        return this.undoneChanges;
    }
}

