/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.InvalidPendingChangeTableException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.WorkspaceVersionTableException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryReader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryWriter;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.CommittedState;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.ServerItemMapper;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItemEnumerable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItemPair;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.ServerItemLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.EnumSubTreeOptions;
import com.microsoft.tfs.core.clients.versioncontrol.sparsetree.SparseTree;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkspaceVersionTable
extends LocalMetadataTable {
    private static final Log log = LogFactory.getLog(WorkspaceVersionTable.class);
    private static final short MAGIC = -22580;
    private static final int SCHEMA_VERSION_2 = 2;
    public SparseTree<WorkspaceLocalItemPair> server;
    public SparseTree<WorkspaceLocalItem> local;
    private List<WorkspaceLocalItem> removedItems;
    private int pendingReconcileCount;

    public WorkspaceVersionTable(String tableLocation, WorkspaceVersionTable cachedLoadSource) throws Exception {
        super(tableLocation, cachedLoadSource);
    }

    @Override
    protected void initialize() {
        this.server = new SparseTree('/', (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        this.local = new SparseTree(File.separatorChar, (Comparator<String>)String.CASE_INSENSITIVE_ORDER);
        this.removedItems = new ArrayList<WorkspaceLocalItem>();
    }

    @Override
    protected void load(InputStream is) throws InvalidPendingChangeTableException, IOException {
        block8: {
            BinaryReader br = new BinaryReader(is, "UTF-16LE");
            try {
                short magic = br.readInt16();
                if (-22580 != magic) {
                    throw new WorkspaceVersionTableException(Messages.getString("WorkspaceVersionTable.InvalidVersionTable"));
                }
                int schemaVersion = br.readInt32();
                if (schemaVersion == 2) {
                    this.loadFromVersion2(br);
                    break block8;
                }
                throw new WorkspaceVersionTableException(Messages.getString("WorkspaceVersionTable.InvalidVersionTable"));
            }
            catch (Exception e) {
                if (e instanceof WorkspaceVersionTableException) {
                    throw (WorkspaceVersionTableException)e;
                }
                throw new WorkspaceVersionTableException(e);
            }
            finally {
                br.close();
            }
        }
    }

    private void loadFromVersion2(BinaryReader br) throws IOException {
        br.readBoolean();
        int rowCount = br.readInt32();
        for (int i = 0; i < rowCount; ++i) {
            WorkspaceLocalItem lvEntry = WorkspaceLocalItem.fromVersion2(br);
            if (null == lvEntry.getLocalItem() && lvEntry.isPendingReconcile() && !lvEntry.isDeleted()) {
                ++this.pendingReconcileCount;
                this.removedItems.add(lvEntry);
                continue;
            }
            this.add(lvEntry, true);
        }
    }

    @Override
    protected boolean cachedLoad(LocalMetadataTable source) {
        WorkspaceVersionTable lvCached = null;
        if (source instanceof WorkspaceVersionTable) {
            lvCached = (WorkspaceVersionTable)source;
        }
        if (null != lvCached) {
            this.pendingReconcileCount = lvCached.pendingReconcileCount;
            this.server = lvCached.server;
            this.local = lvCached.local;
            this.removedItems = lvCached.removedItems;
            source.setEligibleForCachedLoad(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean save(OutputStream os) throws IOException {
        BinaryWriter bw = new BinaryWriter(os, "UTF-16LE");
        try {
            bw.write((short)-22580);
            this.writeToVersion2(bw);
        }
        finally {
            bw.close();
        }
        return true;
    }

    private void writeToVersion2(BinaryWriter bw) throws IOException {
        bw.write(2);
        bw.write(this.getPendingReconcile());
        int count = 0;
        int pendingReconcileCount = 0;
        ArrayList<WorkspaceLocalItemPair> workspaceLocalItemPairs = new ArrayList<WorkspaceLocalItemPair>();
        for (WorkspaceLocalItemPair pair : this.server.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE)) {
            workspaceLocalItemPairs.add(pair);
            if (null != pair.getCommitted()) {
                if (pair.getCommitted().isPendingReconcile()) {
                    ++pendingReconcileCount;
                }
                ++count;
            }
            if (null == pair.getUncommitted()) continue;
            if (pair.getUncommitted().isPendingReconcile()) {
                ++pendingReconcileCount;
            }
            ++count;
        }
        if ((pendingReconcileCount += this.removedItems.size()) != this.pendingReconcileCount) {
            log.error((Object)new Exception("Unexpected pendingReconcileCount != this.pendingReconcileCount"));
        }
        bw.write(count + this.removedItems.size());
        for (WorkspaceLocalItemPair pair : workspaceLocalItemPairs) {
            if (null != pair.getCommitted()) {
                pair.getCommitted().saveToVersion2(bw);
            }
            if (null == pair.getUncommitted()) continue;
            pair.getUncommitted().saveToVersion2(bw);
        }
        for (WorkspaceLocalItem item : this.removedItems) {
            item.saveToVersion2(bw);
        }
    }

    public void add(WorkspaceLocalItem lvEntry) {
        this.add(lvEntry, false);
    }

    private void add(final WorkspaceLocalItem lvEntry, boolean fromLoad) {
        String localItem;
        final AtomicReference atomicMatch = new AtomicReference();
        SparseTree.ModifyInPlaceCallback<WorkspaceLocalItemPair> callback = new SparseTree.ModifyInPlaceCallback<WorkspaceLocalItemPair>(){

            @Override
            public WorkspaceLocalItemPair invoke(String token, WorkspaceLocalItemPair pair, Object param) {
                if (pair == null) {
                    pair = new WorkspaceLocalItemPair();
                }
                if (lvEntry.isCommitted()) {
                    atomicMatch.set(pair.getCommitted());
                    pair.setCommitted(lvEntry);
                } else {
                    atomicMatch.set(pair.getUncommitted());
                    pair.setUncommitted(lvEntry);
                }
                return pair;
            }
        };
        this.server.modifyInPlace(lvEntry.getServerItem(), callback, null);
        WorkspaceLocalItem matchingEntry = (WorkspaceLocalItem)atomicMatch.get();
        this.setDirty(!fromLoad);
        if (null != matchingEntry) {
            localItem = matchingEntry.getLocalItem();
            if (localItem != null && localItem.length() > 0) {
                this.local.remove(localItem, false);
            }
            if (matchingEntry.isPendingReconcile()) {
                --this.pendingReconcileCount;
            }
        }
        if (lvEntry.isPendingReconcile()) {
            ++this.pendingReconcileCount;
        }
        if ((localItem = lvEntry.getLocalItem()) != null && localItem.length() > 0) {
            this.local.add(localItem, lvEntry, true);
        }
    }

    public void markAsReconciled(LocalWorkspaceProperties wp, boolean removeMissingFromDiskRows) {
        ArrayList<WorkspaceLocalItem> missingRowsRemoved = new ArrayList<WorkspaceLocalItem>();
        Iterable<WorkspaceLocalItemPair> pairs = this.server.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE);
        for (WorkspaceLocalItemPair pair : pairs) {
            if (null != pair.getCommitted()) {
                if (pair.getCommitted().isPendingReconcile()) {
                    --this.pendingReconcileCount;
                    pair.getCommitted().setPendingReconcile(false);
                }
                if (removeMissingFromDiskRows && pair.getCommitted().isMissingOnDisk()) {
                    missingRowsRemoved.add(pair.getCommitted());
                }
            }
            if (null == pair.getUncommitted()) continue;
            if (pair.getUncommitted().isPendingReconcile()) {
                --this.pendingReconcileCount;
                pair.getUncommitted().setPendingReconcile(false);
            }
            if (!removeMissingFromDiskRows || !pair.getUncommitted().isMissingOnDisk()) continue;
            missingRowsRemoved.add(pair.getUncommitted());
        }
        for (WorkspaceLocalItem lvEntry : missingRowsRemoved) {
            if (lvEntry.hasBaselineFileGUID()) {
                wp.deleteBaseline(lvEntry.getBaselineFileGUID());
            }
            this.removeByServerItem(lvEntry.getServerItem(), lvEntry.isCommitted(), false);
        }
        this.pendingReconcileCount -= this.removedItems.size();
        this.removedItems.clear();
        Check.isTrue(0 == this.pendingReconcileCount, "0 == pendingReconcileCount");
        this.setDirty(true);
    }

    public WorkspaceLocalItem getByLocalItem(String localItem) {
        Check.notNullOrEmpty(localItem, "localItem");
        return this.local.get(localItem);
    }

    public WorkspaceLocalItem getByServerItem(String serverItem, boolean isCommitted) {
        Check.notNullOrEmpty(serverItem, "serverItem");
        WorkspaceLocalItemPair pair = this.server.get(serverItem);
        if (pair == null) {
            return null;
        }
        if (isCommitted) {
            return pair.getCommitted();
        }
        return pair.getUncommitted();
    }

    public WorkspaceLocalItem getByPendingChange(LocalPendingChange pcEntry) {
        Check.notNull(pcEntry, "pcEntry");
        if (pcEntry.isCommitted()) {
            return this.getByServerItem(pcEntry.getCommittedServerItem(), true);
        }
        return this.getByServerItem(pcEntry.getTargetServerItem(), false);
    }

    public WorkspaceLocalItem getByPendingChange(PendingChange pc) {
        Check.notNull(pc, "pc");
        if (pc.isAdd() || pc.isBranch()) {
            return this.getByServerItem(pc.getServerItem(), false);
        }
        String source = pc.getSourceServerItem();
        String serverItem = source == null || source.length() == 0 ? pc.getServerItem() : source;
        return this.getByServerItem(serverItem, true);
    }

    public WorkspaceLocalItem getByGetOperation(GetOperation getOp) {
        Check.notNull(getOp, "getOp");
        ChangeType change = getOp.getChangeType();
        if (change.contains(ChangeType.ADD) || change.contains(ChangeType.BRANCH)) {
            return this.getByServerItem(getOp.getTargetServerItem(), false);
        }
        return this.getByServerItem(getOp.getSourceServerItem(), true);
    }

    public Iterable<WorkspaceLocalItem> queryLocalItemRoots() {
        return this.local.EnumRootsReferencedObjects();
    }

    public Iterable<WorkspaceLocalItem> queryByLocalItem(String localItem, RecursionType recursion, String pattern) {
        return this.queryByLocalItem(localItem, recursion, pattern, false);
    }

    public Iterable<WorkspaceLocalItem> queryByLocalItem(String localItem, RecursionType recursion, String pattern, boolean includeDeleted) {
        return new WorkspaceLocalItemEnumerable(this, recursion, localItem, pattern, includeDeleted);
    }

    public Iterable<WorkspaceLocalItem> queryByServerItem(String serverItem, RecursionType recursion, String pattern) {
        return this.queryByServerItem(serverItem, recursion, pattern, CommittedState.BOTH, false);
    }

    public Iterable<WorkspaceLocalItem> queryByServerItem(String serverItem, RecursionType recursion, String pattern, boolean includeDeleted) {
        return this.queryByServerItem(serverItem, recursion, pattern, CommittedState.BOTH, includeDeleted);
    }

    public Iterable<WorkspaceLocalItem> queryByServerItem(String serverItem, RecursionType recursion, String pattern, CommittedState committedState, boolean includeDeleted) {
        Check.notNullOrEmpty(serverItem, "serverItem");
        return new WorkspaceLocalItemEnumerable(this, recursion, serverItem, committedState, pattern, includeDeleted);
    }

    public void removeByLocalItem(String localItem, boolean queueForReconcile) {
        WorkspaceLocalItem lvEntry;
        if (localItem != null && localItem.length() > 0 && (lvEntry = this.local.get(localItem)) != null) {
            this.setDirty(true);
            this.local.remove(localItem, false);
            this.removeFromServerIndex(lvEntry.getServerItem(), lvEntry.isCommitted());
            if (queueForReconcile) {
                this.queueForReconcile(lvEntry);
            }
        }
    }

    public void removeByServerItem(String serverItem, boolean isCommitted, boolean queueForReconcile) {
        WorkspaceLocalItem lvEntry = this.getByServerItem(serverItem, isCommitted);
        if (null != lvEntry) {
            this.setDirty(true);
            this.removeFromServerIndex(serverItem, isCommitted);
            if (lvEntry.getLocalItem() != null && lvEntry.getLocalItem().length() > 0) {
                this.local.remove(lvEntry.getLocalItem(), false);
            }
            if (queueForReconcile) {
                this.queueForReconcile(lvEntry);
            }
        }
    }

    private void queueForReconcile(WorkspaceLocalItem lvEntry) {
        WorkspaceLocalItem removed = lvEntry.clone();
        removed.setPendingReconcile(true);
        removed.setDeleted(false);
        removed.setLocalItem(null);
        ++this.pendingReconcileCount;
        this.removedItems.add(removed);
    }

    private void removeFromServerIndex(String serverItem, boolean isCommitted) {
        WorkspaceLocalItemPair pair = this.server.get(serverItem);
        if (pair != null) {
            if (isCommitted) {
                if (null != pair.getCommitted() && pair.getCommitted().isPendingReconcile()) {
                    --this.pendingReconcileCount;
                }
                pair.setCommitted(null);
            } else {
                if (null != pair.getUncommitted() && pair.getUncommitted().isPendingReconcile()) {
                    --this.pendingReconcileCount;
                }
                pair.setUncommitted(null);
            }
            if (null == pair.getCommitted() && null == pair.getUncommitted()) {
                this.server.remove(serverItem, false);
            } else {
                this.server.add(serverItem, pair, true);
            }
        }
    }

    public void markAsDeleted(String serverItem, boolean isCommitted, boolean pendingReconcile) {
        WorkspaceLocalItem lvEntry = this.getByServerItem(serverItem, isCommitted);
        if (null != lvEntry) {
            this.setDirty(true);
            lvEntry.setDeleted(true);
            lvEntry.setMissingOnDisk(false);
            if (pendingReconcile && !lvEntry.isPendingReconcile()) {
                ++this.pendingReconcileCount;
            }
            lvEntry.setPendingReconcile(lvEntry.isPendingReconcile() || pendingReconcile);
            if (lvEntry.getLocalItem() != null && lvEntry.getLocalItem().length() > 0) {
                this.local.remove(lvEntry.getLocalItem(), false);
            }
            lvEntry.setLocalItem(null);
        }
    }

    public ServerItemLocalVersionUpdate[] getUpdatesForReconcile(LocalPendingChange[] pendingChanges, boolean reconcileMissingOnDisk, AtomicBoolean outClearLocalVersionTable) {
        outClearLocalVersionTable.set(true);
        HashSet<ServerItemLocalVersionUpdate> updates = new HashSet<ServerItemLocalVersionUpdate>();
        Iterable<WorkspaceLocalItemPair> pairs = this.server.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE);
        for (WorkspaceLocalItemPair pair : pairs) {
            ServerItemLocalVersionUpdate update;
            if (pair.getCommitted() != null) {
                if (outClearLocalVersionTable.get() && !pair.getCommitted().isPendingReconcile()) {
                    outClearLocalVersionTable.set(false);
                }
                if (null != (update = pair.getCommitted().getLocalVersionUpdate(reconcileMissingOnDisk))) {
                    updates.add(update);
                }
            }
            if (pair.getUncommitted() == null) continue;
            if (outClearLocalVersionTable.get() && !pair.getUncommitted().isPendingReconcile()) {
                outClearLocalVersionTable.set(false);
            }
            if (null == (update = pair.getUncommitted().getLocalVersionUpdate(reconcileMissingOnDisk))) continue;
            updates.add(update);
        }
        for (WorkspaceLocalItem lvEntry : this.removedItems) {
            if (null != this.getByServerItem(lvEntry.getServerItem(), lvEntry.isCommitted())) continue;
            updates.add(lvEntry.getLocalVersionUpdate());
        }
        for (LocalPendingChange pc : pendingChanges) {
            WorkspaceLocalItem lvEntry = this.getByServerItem(pc.isCommitted() ? pc.getCommittedServerItem() : pc.getTargetServerItem(), pc.isCommitted());
            if (lvEntry == null) continue;
            if (!lvEntry.isPendingReconcile()) {
                lvEntry.setPendingReconcile(true);
                ++this.pendingReconcileCount;
            }
            updates.add(lvEntry.getLocalVersionUpdate(reconcileMissingOnDisk));
        }
        return updates.toArray(new ServerItemLocalVersionUpdate[updates.size()]);
    }

    public List<String> getKnownServerItems() {
        ArrayList<String> knownServerItems = new ArrayList<String>();
        for (WorkspaceLocalItemPair pair : this.server.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE)) {
            knownServerItems.add(pair.getServerItem());
        }
        for (WorkspaceLocalItem lvEntry : this.removedItems) {
            knownServerItems.add(lvEntry.getServerItem());
        }
        return knownServerItems;
    }

    public void renameTeamProjects(ServerItemMapper serverItemMapper) {
        int newPendingReconcileCount = 0;
        this.setDirty(true);
        this.local.clear();
        ArrayList<WorkspaceLocalItemPair> pairs = new ArrayList<WorkspaceLocalItemPair>(this.server.getCount());
        for (WorkspaceLocalItemPair pair : this.server.EnumSubTreeReferencedObjects("$/", EnumSubTreeOptions.ENUMERATE_SUB_TREE_ROOT, Integer.MAX_VALUE)) {
            WorkspaceLocalItem committed = null;
            WorkspaceLocalItem uncommitted = null;
            if (pair.getCommitted() != null) {
                committed = pair.getCommitted().clone();
                committed.setServerItem(serverItemMapper.map(committed.getServerItem()));
                committed.setPendingReconcile(true);
                if (committed.getLocalItem() != null) {
                    this.local.add(committed.getLocalItem(), committed);
                }
                ++newPendingReconcileCount;
            }
            if (pair.getUncommitted() != null) {
                uncommitted = pair.getUncommitted().clone();
                uncommitted.setServerItem(serverItemMapper.map(uncommitted.getServerItem()));
                uncommitted.setPendingReconcile(true);
                if (uncommitted.getLocalItem() != null) {
                    this.local.add(uncommitted.getLocalItem(), uncommitted);
                }
                ++newPendingReconcileCount;
            }
            WorkspaceLocalItemPair newPair = new WorkspaceLocalItemPair();
            newPair.setCommitted(committed);
            newPair.setUncommitted(uncommitted);
            pairs.add(newPair);
        }
        this.server.clear();
        for (WorkspaceLocalItemPair pair : pairs) {
            this.server.add(pair.getServerItem(), pair);
        }
        ArrayList<WorkspaceLocalItem> newRemovedItems = new ArrayList<WorkspaceLocalItem>();
        for (WorkspaceLocalItem lvEntry : newRemovedItems) {
            WorkspaceLocalItem renamedEntry = lvEntry.clone();
            renamedEntry.setServerItem(serverItemMapper.map(renamedEntry.getServerItem()));
            newRemovedItems.add(renamedEntry);
            ++newPendingReconcileCount;
        }
        this.removedItems = newRemovedItems;
        this.pendingReconcileCount = newPendingReconcileCount;
    }

    public int getLocalItemsCount() {
        return this.local.getCount();
    }

    public boolean getPendingReconcile() {
        return this.pendingReconcileCount > 0;
    }
}

