/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.query.DisplayFieldList;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class DisplayFieldListImpl
implements DisplayFieldList {
    private final WITContext context;
    private final List<FieldDefinition> displayFields = new ArrayList<FieldDefinition>();

    public DisplayFieldListImpl(WITContext context) {
        this.context = context;
    }

    @Override
    public void add(FieldDefinition fieldDefinition) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("fieldDefinition must not be null");
        }
        if (!fieldDefinition.isQueryable()) {
            throw new IllegalArgumentException(MessageFormat.format("fieldDefinition [{0}] is not queryable", fieldDefinition));
        }
        if (!this.displayFields.contains(fieldDefinition)) {
            this.displayFields.add(fieldDefinition);
        }
    }

    @Override
    public void add(String fieldName) {
        this.add(this.context.getClient().getFieldDefinitions().get(fieldName));
    }

    @Override
    public int getSize() {
        return this.displayFields.size();
    }

    @Override
    public FieldDefinition getField(int index) {
        return this.displayFields.get(index);
    }

    @Override
    public int indexOf(FieldDefinition fieldDefinition) {
        return this.displayFields.indexOf(fieldDefinition);
    }

    @Override
    public void clear() {
        this.displayFields.clear();
    }
}

