/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.internal.db;

import com.microsoft.tfs.core.internal.db.DBException;
import com.microsoft.tfs.core.internal.db.ResultHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBStatement {
    private static final Log log = LogFactory.getLog(DBStatement.class);
    private final Connection connection;
    private final String sql;
    private PreparedStatement ps;

    public DBStatement(Connection connection, String sql) {
        this.connection = connection;
        this.sql = sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(Object params) {
        int n;
        int rowCount;
        long startTime;
        block12: {
            boolean closePs = false;
            startTime = System.currentTimeMillis();
            rowCount = 0;
            try {
                if (this.ps == null) {
                    this.ps = this.connection.prepareStatement(this.sql);
                    closePs = true;
                }
                this.setParameters(this.ps, params);
                n = rowCount = this.ps.executeUpdate();
                if (!closePs || this.ps == null) break block12;
            }
            catch (Exception ex) {
                try {
                    closePs = true;
                    throw new DBException(ex, this.sql);
                }
                catch (Throwable throwable) {
                    if (closePs && this.ps != null) {
                        try {
                            this.ps.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (log.isTraceEnabled()) {
                        long elapsed2 = System.currentTimeMillis() - startTime;
                        log.trace((Object)MessageFormat.format("query (elapsed={0} rows={1}): {2}", elapsed2, rowCount, this.sql));
                    }
                    throw throwable;
                }
            }
            try {
                this.ps.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (log.isTraceEnabled()) {
            long elapsed = System.currentTimeMillis() - startTime;
            log.trace((Object)MessageFormat.format("query (elapsed={0} rows={1}): {2}", elapsed, rowCount, this.sql));
        }
        return n;
    }

    public int executeUpdate() {
        return this.executeUpdate(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeQuery(Object params, ResultHandler handler) {
        int rowCount;
        long startTime;
        boolean closePs;
        block17: {
            closePs = false;
            ResultSet rset = null;
            startTime = System.currentTimeMillis();
            rowCount = 0;
            try {
                if (this.ps == null) {
                    this.ps = this.connection.prepareStatement(this.sql);
                    closePs = true;
                }
                this.setParameters(this.ps, params);
                rset = this.ps.executeQuery();
                while (rset.next()) {
                    ++rowCount;
                    handler.handleRow(rset);
                }
                if (rset == null) break block17;
            }
            catch (Exception ex) {
                try {
                    closePs = true;
                    throw new DBException(ex, this.sql);
                }
                catch (Throwable throwable) {
                    if (rset != null) {
                        try {
                            rset.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (closePs && this.ps != null) {
                        try {
                            this.ps.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    if (!log.isTraceEnabled()) throw throwable;
                    long elapsed2 = System.currentTimeMillis() - startTime;
                    log.trace((Object)MessageFormat.format("query (elapsed={0} rows={1}): {2}", elapsed2, rowCount, this.sql));
                    throw throwable;
                }
            }
            try {
                rset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (closePs && this.ps != null) {
            try {
                this.ps.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (!log.isTraceEnabled()) return;
        long elapsed = System.currentTimeMillis() - startTime;
        log.trace((Object)MessageFormat.format("query (elapsed={0} rows={1}): {2}", elapsed, rowCount, this.sql));
    }

    public void executeQuery(ResultHandler handler) {
        this.executeQuery(null, handler);
    }

    public String executeStringQuery(Object params) {
        SingleRowSingleColumnHandler h = new SingleRowSingleColumnHandler();
        this.executeQuery(params, h);
        Object obj = h.result;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Clob) {
            try {
                return this.clobToString((Clob)obj);
            }
            catch (SQLException e) {
                throw new DBException("Error converting Clob to String", e);
            }
            catch (IOException e) {
                throw new DBException("Error converting Clob to String", e);
            }
        }
        throw new DBException(MessageFormat.format("unknown return type [{0}] from query [{1}]", obj.getClass().getName(), this.sql));
    }

    private String clobToString(Clob clob) throws SQLException, IOException {
        int len;
        StringWriter writer = new StringWriter();
        Reader reader = clob.getCharacterStream();
        char[] buf = new char[2048];
        while ((len = reader.read(buf)) != -1) {
            writer.write(buf, 0, len);
        }
        return writer.toString();
    }

    public String executeStringQuery() {
        return this.executeStringQuery(null);
    }

    public long executeNumericQuery(Object params) {
        SingleRowSingleColumnHandler h = new SingleRowSingleColumnHandler();
        this.executeQuery(params, h);
        Object r = h.result;
        if (r instanceof Long) {
            return (Long)r;
        }
        if (r instanceof Integer) {
            return ((Integer)r).longValue();
        }
        if (r instanceof Short) {
            return ((Short)r).longValue();
        }
        if (r instanceof Byte) {
            return ((Byte)r).longValue();
        }
        log.error((Object)("Unexpected result type of a numeric query - " + r.getClass().getName()), (Throwable)new Exception("Fake exception to display the call stack"));
        return 0L;
    }

    public long executeNumericQuery() {
        return this.executeNumericQuery(null);
    }

    public Long executeLongQuery(Object params) {
        SingleRowSingleColumnHandler h = new SingleRowSingleColumnHandler();
        this.executeQuery(params, h);
        return (Long)h.result;
    }

    public Long executeLongQuery() {
        return this.executeLongQuery(null);
    }

    public Integer executeIntQuery(Object params) {
        SingleRowSingleColumnHandler h = new SingleRowSingleColumnHandler();
        this.executeQuery(params, h);
        return (Integer)h.result;
    }

    public Integer executeIntQuery() {
        return this.executeIntQuery(null);
    }

    public Object[] executeMultiColumnQuery(Object params) {
        SingleRowMultipleColumnsHandler h = new SingleRowMultipleColumnsHandler();
        this.executeQuery(params, h);
        return h.results;
    }

    public Object[] executeMultiColumnQuery() {
        return this.executeMultiColumnQuery(null);
    }

    public Object executeQueryForPrimitiveArray(Object params, Class primitiveType) {
        if (primitiveType == null || !primitiveType.isPrimitive()) {
            throw new IllegalArgumentException("primitiveType must be a non-null primitive type");
        }
        final ArrayList results = new ArrayList();
        this.executeQuery(params, new ResultHandler(){

            @Override
            public void handleRow(ResultSet rset) throws SQLException {
                results.add(rset.getObject(1));
            }
        });
        int len = results.size();
        Object returnArray = Array.newInstance(primitiveType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(returnArray, i, results.get(i));
        }
        return returnArray;
    }

    public Object executeQueryForPrimitiveArray(Class primitiveType) {
        return this.executeQueryForPrimitiveArray(null, primitiveType);
    }

    private void setParameters(PreparedStatement ps, Object args) throws SQLException {
        if (args == null) {
            return;
        }
        if (!args.getClass().isArray()) {
            ps.setObject(1, args);
        } else {
            int len = Array.getLength(args);
            for (int i = 0; i < len; ++i) {
                ps.setObject(i + 1, Array.get(args, i));
            }
        }
    }

    public void beginBatch() {
        try {
            this.ps = this.connection.prepareStatement(this.sql);
        }
        catch (SQLException e) {
            throw new DBException(e, this.sql);
        }
    }

    public void finishBatch() {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (SQLException e) {
                throw new DBException(e, this.sql);
            }
        }
    }

    private class SingleRowMultipleColumnsHandler
    implements ResultHandler {
        public Object[] results = null;
        private int rowCount = 0;

        private SingleRowMultipleColumnsHandler() {
        }

        @Override
        public void handleRow(ResultSet rset) throws SQLException {
            ++this.rowCount;
            if (this.rowCount > 1) {
                throw new RuntimeException(MessageFormat.format("the query [{0}] returned more than one row", DBStatement.this.sql));
            }
            int colCount = rset.getMetaData().getColumnCount();
            this.results = new Object[colCount];
            for (int i = 0; i < this.results.length; ++i) {
                this.results[i] = rset.getObject(i + 1);
            }
        }
    }

    private class SingleRowSingleColumnHandler
    implements ResultHandler {
        public Object result = null;
        private int rowCount = 0;

        private SingleRowSingleColumnHandler() {
        }

        @Override
        public void handleRow(ResultSet rset) throws SQLException {
            ++this.rowCount;
            if (this.rowCount > 1) {
                throw new RuntimeException(MessageFormat.format("the query [{0}] returned more than one row", DBStatement.this.sql));
            }
            this.result = rset.getObject(1);
        }
    }
}

