/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.serverlist;

import com.microsoft.tfs.core.util.serverlist.ServerListEntry;
import com.microsoft.tfs.core.util.serverlist.ServerListEntryType;
import java.net.URI;

public class ServerListCollectionEntry
extends ServerListEntry
implements Comparable<ServerListCollectionEntry> {
    private Boolean offline;

    public ServerListCollectionEntry(String name, ServerListEntryType type, URI uri) {
        this(name, type, uri, null);
    }

    public ServerListCollectionEntry(String name, ServerListEntryType type, URI uri, Boolean offline) {
        super(name, type, uri);
        this.offline = offline;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    @Override
    public int compareTo(ServerListCollectionEntry other) {
        int result = super.compareTo(other);
        if (result != 0) {
            return result;
        }
        if (this.offline == null && other.offline != null) {
            return -1;
        }
        if (this.offline != null && other.offline == null) {
            return 1;
        }
        if (this.offline != null && other.offline != null) {
            if (!this.offline.booleanValue() && other.offline.booleanValue()) {
                return -1;
            }
            if (this.offline.booleanValue() && !other.offline.booleanValue()) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.offline != null) {
            result = result * 37 + (this.offline != false ? 1 : 0);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerListCollectionEntry)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ServerListCollectionEntry other = (ServerListCollectionEntry)o;
        if (!super.equals(other)) {
            return false;
        }
        if (this.offline != null ^ other.offline != null) {
            return false;
        }
        return this.offline == null || other.offline == null || this.offline.equals(other.offline);
    }
}

